/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public final class JarUtils {
    private static final Path THIS_JAR;
    private static final Manifest manifest;

    private JarUtils() {
    }

    @Nullable
    public static Path thisJarPath() {
        return THIS_JAR;
    }

    public static String getManifestAttribute(String name, String defaultValue) {
        String value = manifest.getMainAttributes().getValue(name);
        return value != null ? value : defaultValue;
    }

    static {
        CodeSource cs = JarUtils.class.getProtectionDomain().getCodeSource();
        if (cs == null) {
            THIS_JAR = null;
            manifest = new Manifest();
        } else {
            Path path;
            try {
                path = Paths.get(cs.getLocation().toURI()).toAbsolutePath();
            }
            catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
                path = null;
            }
            if (path == null || !Files.isRegularFile(path, new LinkOption[0])) {
                THIS_JAR = null;
                manifest = new Manifest();
            } else {
                Manifest mn;
                THIS_JAR = path;
                try (JarFile file = new JarFile(path.toFile());){
                    mn = file.getManifest();
                }
                catch (IOException e) {
                    mn = new Manifest();
                }
                manifest = mn;
            }
        }
    }
}

