/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.KeyValuePairUtils;
import org.jackhuang.hmcl.util.platform.windows.Kernel32;
import org.jackhuang.hmcl.util.platform.windows.WinTypes;
import org.jackhuang.hmcl.util.platform.windows.WindowsVersion;
import org.jetbrains.annotations.Nullable;

public final class OperatingSystem
extends Enum<OperatingSystem> {
    public static final /* enum */ OperatingSystem WINDOWS;
    public static final /* enum */ OperatingSystem LINUX;
    public static final /* enum */ OperatingSystem MACOS;
    public static final /* enum */ OperatingSystem FREEBSD;
    public static final /* enum */ OperatingSystem UNKNOWN;
    private final String checkedName;
    private final String mojangName;
    public static final OperatingSystem CURRENT_OS;
    public static final Charset NATIVE_CHARSET;
    public static final int SYSTEM_BUILD_NUMBER;
    @Nullable
    public static final WindowsVersion WINDOWS_VERSION;
    public static final String SYSTEM_NAME;
    public static final String SYSTEM_VERSION;
    public static final String OS_RELEASE_NAME;
    public static final String OS_RELEASE_PRETTY_NAME;
    public static final int CODE_PAGE;
    public static final Pattern INVALID_RESOURCE_CHARACTERS;
    private static final String[] INVALID_RESOURCE_BASENAMES;
    private static final String[] INVALID_RESOURCE_FULLNAMES;
    private static final /* synthetic */ OperatingSystem[] $VALUES;

    public static OperatingSystem[] values() {
        return (OperatingSystem[])$VALUES.clone();
    }

    public static OperatingSystem valueOf(String name) {
        return Enum.valueOf(OperatingSystem.class, name);
    }

    private OperatingSystem(String checkedName) {
        this.checkedName = checkedName;
        this.mojangName = checkedName;
    }

    private OperatingSystem(String checkedName, String mojangName) {
        this.checkedName = checkedName;
        this.mojangName = mojangName;
    }

    public String getCheckedName() {
        return this.checkedName;
    }

    public String getMojangName() {
        return this.mojangName;
    }

    public boolean isLinuxOrBSD() {
        return this == LINUX || this == FREEBSD;
    }

    public String getJavaExecutable() {
        return this == WINDOWS ? "java.exe" : "java";
    }

    public static OperatingSystem parseOSName(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        if ((name = name.trim().toLowerCase(Locale.ROOT)).contains("mac") || name.contains("darwin") || name.contains("osx")) {
            return MACOS;
        }
        if (name.contains("win")) {
            return WINDOWS;
        }
        if (name.contains("solaris") || name.contains("linux") || name.contains("unix") || name.contains("sunos")) {
            return LINUX;
        }
        if (name.equals("freebsd")) {
            return FREEBSD;
        }
        return UNKNOWN;
    }

    public static boolean isWindows7OrLater() {
        return WINDOWS_VERSION != null && WINDOWS_VERSION.compareTo(WindowsVersion.WINDOWS_7) >= 0;
    }

    public static Path getWorkingDirectory(String folder) {
        String home = System.getProperty("user.home", ".");
        switch (CURRENT_OS.ordinal()) {
            case 1: 
            case 3: {
                return Paths.get(home, "." + folder).toAbsolutePath();
            }
            case 0: {
                String appdata = System.getenv("APPDATA");
                return Paths.get(appdata == null ? home : appdata, "." + folder).toAbsolutePath();
            }
            case 2: {
                return Paths.get(home, "Library", "Application Support", folder).toAbsolutePath();
            }
        }
        return Paths.get(home, folder).toAbsolutePath();
    }

    public static boolean isNameValid(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (name.equals(".")) {
            return false;
        }
        if (name.indexOf(47) != -1 || name.indexOf(0) != -1) {
            return false;
        }
        if (CURRENT_OS == WINDOWS) {
            String basename;
            char lastChar = name.charAt(name.length() - 1);
            if (lastChar == '.') {
                return false;
            }
            if (Character.isWhitespace(lastChar)) {
                return false;
            }
            int dot = name.indexOf(46);
            String string = basename = dot == -1 ? name : name.substring(0, dot);
            if (Arrays.binarySearch(INVALID_RESOURCE_BASENAMES, basename.toLowerCase(Locale.ROOT)) >= 0) {
                return false;
            }
            if (Arrays.binarySearch(INVALID_RESOURCE_FULLNAMES, name.toLowerCase(Locale.ROOT)) >= 0) {
                return false;
            }
            if (INVALID_RESOURCE_CHARACTERS.matcher(name).find()) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ OperatingSystem[] $values() {
        return new OperatingSystem[]{WINDOWS, LINUX, MACOS, FREEBSD, UNKNOWN};
    }

    static {
        Path osReleaseFile;
        WINDOWS = new OperatingSystem("windows");
        LINUX = new OperatingSystem("linux");
        MACOS = new OperatingSystem("macos", "osx");
        FREEBSD = new OperatingSystem("freebsd", "linux");
        UNKNOWN = new OperatingSystem("universal");
        $VALUES = OperatingSystem.$values();
        CURRENT_OS = OperatingSystem.parseOSName(System.getProperty("os.name"));
        String nativeEncoding = System.getProperty("native.encoding");
        String hmclNativeEncoding = System.getProperty("hmcl.native.encoding");
        Charset nativeCharset = Charset.defaultCharset();
        try {
            if (hmclNativeEncoding != null) {
                nativeCharset = Charset.forName(hmclNativeEncoding);
            } else {
                if (nativeEncoding != null && !nativeEncoding.equalsIgnoreCase(nativeCharset.name())) {
                    nativeCharset = Charset.forName(nativeEncoding);
                }
                if (nativeCharset == StandardCharsets.UTF_8 || nativeCharset == StandardCharsets.US_ASCII) {
                    nativeCharset = StandardCharsets.UTF_8;
                } else if ("GBK".equalsIgnoreCase(nativeCharset.name()) || "GB2312".equalsIgnoreCase(nativeCharset.name())) {
                    nativeCharset = Charset.forName("GB18030");
                }
            }
        }
        catch (UnsupportedCharsetException e) {
            e.printStackTrace(System.err);
        }
        NATIVE_CHARSET = nativeCharset;
        if (CURRENT_OS == WINDOWS) {
            Matcher matcher;
            BufferedReader reader;
            Process process2;
            int codePage = -1;
            WindowsVersion windowsVersion = null;
            Kernel32 kernel32 = Kernel32.INSTANCE;
            if (kernel32 != null) {
                WinTypes.OSVERSIONINFOEXW osVersionInfo = new WinTypes.OSVERSIONINFOEXW();
                if (kernel32.GetVersionExW(osVersionInfo)) {
                    windowsVersion = new WindowsVersion(osVersionInfo.dwMajorVersion, osVersionInfo.dwMinorVersion, osVersionInfo.dwBuildNumber);
                } else {
                    System.err.println("Failed to obtain OS version number (" + kernel32.GetLastError() + ")");
                }
            }
            if (windowsVersion == null) {
                try {
                    process2 = Runtime.getRuntime().exec(new String[]{"cmd", "ver"});
                    reader = new BufferedReader(new InputStreamReader(process2.getInputStream(), NATIVE_CHARSET));
                    try {
                        matcher = Pattern.compile("(?<version>\\d+\\.\\d+\\.\\d+\\.\\d+?)]$").matcher(reader.readLine().trim());
                        if (matcher.find()) {
                            windowsVersion = new WindowsVersion(matcher.group("version"));
                        }
                    }
                    finally {
                        reader.close();
                    }
                    process2.destroy();
                }
                catch (Throwable process2) {
                    // empty catch block
                }
            }
            if (windowsVersion == null) {
                windowsVersion = new WindowsVersion(System.getProperty("os.version"));
            }
            if (kernel32 != null) {
                codePage = kernel32.GetACP();
            } else {
                try {
                    process2 = Runtime.getRuntime().exec(new String[]{"chcp.com"});
                    reader = new BufferedReader(new InputStreamReader(process2.getInputStream(), NATIVE_CHARSET));
                    try {
                        matcher = Pattern.compile("(?<cp>[0-9]+)$").matcher(reader.readLine().trim());
                        if (matcher.find()) {
                            codePage = Integer.parseInt(matcher.group("cp"));
                        }
                    }
                    finally {
                        reader.close();
                    }
                    process2.destroy();
                }
                catch (Throwable process3) {
                    // empty catch block
                }
            }
            String osName = System.getProperty("os.name");
            if (osName.equals("Windows 10") && windowsVersion.compareTo(WindowsVersion.WINDOWS_11) >= 0) {
                osName = "Windows 11";
            }
            SYSTEM_NAME = osName;
            SYSTEM_VERSION = windowsVersion.toString();
            SYSTEM_BUILD_NUMBER = windowsVersion.getBuild();
            WINDOWS_VERSION = windowsVersion;
            CODE_PAGE = codePage;
        } else {
            SYSTEM_NAME = System.getProperty("os.name");
            SYSTEM_VERSION = System.getProperty("os.version");
            SYSTEM_BUILD_NUMBER = -1;
            WINDOWS_VERSION = null;
            CODE_PAGE = -1;
        }
        Map<Object, Object> osRelease = Collections.emptyMap();
        if ((CURRENT_OS == LINUX || CURRENT_OS == FREEBSD) && Files.exists(osReleaseFile = Paths.get("/etc/os-release", new String[0]), new LinkOption[0])) {
            try {
                osRelease = KeyValuePairUtils.loadProperties(osReleaseFile);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        OS_RELEASE_NAME = (String)osRelease.get("NAME");
        OS_RELEASE_PRETTY_NAME = (String)osRelease.get("PRETTY_NAME");
        if (CURRENT_OS == WINDOWS) {
            INVALID_RESOURCE_CHARACTERS = Pattern.compile("[/\"<>|?*:\\\\]");
            INVALID_RESOURCE_BASENAMES = new String[]{"aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
            Arrays.sort(INVALID_RESOURCE_BASENAMES);
            INVALID_RESOURCE_FULLNAMES = new String[]{"clock$"};
        } else {
            INVALID_RESOURCE_CHARACTERS = null;
            INVALID_RESOURCE_BASENAMES = null;
            INVALID_RESOURCE_FULLNAMES = null;
        }
    }
}

