/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.utils;

import java.nio.file.Path;

public class FileNameUtils {
    private static String fileNameToBaseName(String name) {
        int extensionIndex = name.lastIndexOf(46);
        return extensionIndex < 0 ? name : name.substring(0, extensionIndex);
    }

    private static String fileNameToExtension(String name) {
        int extensionIndex = name.lastIndexOf(46);
        return extensionIndex < 0 ? "" : name.substring(extensionIndex + 1);
    }

    public static String getFileName(String path) {
        char ch;
        int end;
        for (end = path.length(); end > 0 && ((ch = path.charAt(end - 1)) == '/' || ch == '\\'); --end) {
        }
        if (end == 0) {
            return "";
        }
        for (int start = end - 1; start > 0; --start) {
            char ch2 = path.charAt(start);
            if (ch2 != '/' && ch2 != '\\') continue;
            return path.substring(start + 1, end);
        }
        return path;
    }

    public static String getBaseName(Path path) {
        if (path == null) {
            return null;
        }
        Path fileName = path.getFileName();
        return fileName != null ? FileNameUtils.fileNameToBaseName(fileName.toString()) : null;
    }

    public static String getBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        return FileNameUtils.fileNameToBaseName(FileNameUtils.getFileName(fileName));
    }

    public static String getExtension(Path path) {
        if (path == null) {
            return null;
        }
        Path fileName = path.getFileName();
        return fileName != null ? FileNameUtils.fileNameToExtension(fileName.toString()) : null;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        return FileNameUtils.fileNameToExtension(FileNameUtils.getFileName(fileName));
    }
}

