/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXRippler;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class TabHeader
extends Control
implements TabControl,
PageAware {
    private ObservableList<TabControl.Tab<?>> tabs = FXCollections.observableArrayList();
    private ObjectProperty<Side> side = new SimpleObjectProperty((Object)Side.TOP);
    private final ObjectProperty<SingleSelectionModel<TabControl.Tab<?>>> selectionModel = new SimpleObjectProperty((Object)this, "selectionModel", (Object)new TabControl.TabControlSelectionModel(this));

    public TabHeader(TabControl.Tab<?> ... tabs) {
        this.getStyleClass().setAll((Object[])new String[]{"tab-header"});
        if (tabs != null) {
            this.getTabs().addAll((Object[])tabs);
        }
    }

    @Override
    public ObservableList<TabControl.Tab<?>> getTabs() {
        return this.tabs;
    }

    public SingleSelectionModel<TabControl.Tab<?>> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public ObjectProperty<SingleSelectionModel<TabControl.Tab<?>>> selectionModelProperty() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel<TabControl.Tab<?>> selectionModel) {
        this.selectionModel.set(selectionModel);
    }

    public void select(TabControl.Tab<?> tab) {
        TabControl.Tab oldTab = (TabControl.Tab)this.getSelectionModel().getSelectedItem();
        if (oldTab != null && oldTab.getNode() instanceof PageAware) {
            ((PageAware)oldTab.getNode()).onPageHidden();
        }
        tab.initializeIfNeeded();
        if (tab.getNode() instanceof PageAware) {
            ((PageAware)tab.getNode()).onPageShown();
        }
        this.getSelectionModel().select(tab);
    }

    @Override
    public void onPageShown() {
        TabControl.Tab tab = (TabControl.Tab)this.getSelectionModel().getSelectedItem();
        if (tab != null && tab.getNode() instanceof PageAware) {
            ((PageAware)tab.getNode()).onPageShown();
        }
    }

    @Override
    public void onPageHidden() {
        TabControl.Tab tab = (TabControl.Tab)this.getSelectionModel().getSelectedItem();
        if (tab != null && tab.getNode() instanceof PageAware) {
            ((PageAware)tab.getNode()).onPageHidden();
        }
    }

    public Side getSide() {
        return (Side)this.side.get();
    }

    public ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side.set((Object)side);
    }

    protected Skin<?> createDefaultSkin() {
        return new TabHeaderSkin(this);
    }

    public static class TabHeaderSkin
    extends SkinBase<TabHeader> {
        private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
        private final Color ripplerColor = Color.valueOf((String)"#FFFF8D");
        private final HeaderContainer header = new HeaderContainer();
        private boolean isSelectingTab = false;
        private TabControl.Tab<?> selectedTab;

        protected TabHeaderSkin(TabHeader control) {
            super((Control)control);
            this.getChildren().setAll((Object[])new Node[]{this.header});
            FXUtils.onChangeAndOperate(control.getSelectionModel().selectedItemProperty(), item -> {
                this.isSelectingTab = true;
                this.selectedTab = item;
                Platform.runLater(() -> {
                    this.header.setNeedsLayout2(true);
                    this.header.layout();
                });
            });
            this.selectedTab = (TabControl.Tab)control.getSelectionModel().getSelectedItem();
            if (this.selectedTab == null && control.getSelectionModel().getSelectedIndex() != -1) {
                control.getSelectionModel().select(control.getSelectionModel().getSelectedIndex());
                this.selectedTab = (TabControl.Tab)control.getSelectionModel().getSelectedItem();
            }
            if (this.selectedTab == null) {
                control.getSelectionModel().selectFirst();
            }
            this.selectedTab = (TabControl.Tab)control.getSelectionModel().getSelectedItem();
        }

        protected class HeaderContainer
        extends StackPane {
            private Timeline timeline;
            private StackPane selectedTabLine;
            private HeadersRegion headersRegion;
            private Scale scale = new Scale(1.0, 1.0, 0.0, 0.0);
            private Rotate rotate = new Rotate(0.0, 0.0, 1.0);
            private double selectedTabLineOffset;
            private ObservableList<Node> binding;

            public HeaderContainer() {
                this.getStyleClass().add((Object)"tab-header-area");
                this.setPickOnBounds(false);
                this.headersRegion = new HeadersRegion();
                this.headersRegion.sideProperty().bind(((TabHeader)TabHeaderSkin.this.getSkinnable()).sideProperty());
                this.selectedTabLine = new StackPane();
                this.selectedTabLine.setManaged(false);
                this.selectedTabLine.getTransforms().addAll((Object[])new Transform[]{this.scale, this.rotate});
                this.selectedTabLine.setCache(true);
                this.selectedTabLine.getStyleClass().addAll((Object[])new String[]{"tab-selected-line"});
                this.selectedTabLine.setPrefHeight(2.0);
                this.selectedTabLine.setPrefWidth(2.0);
                this.selectedTabLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)TabHeaderSkin.this.ripplerColor, CornerRadii.EMPTY, Insets.EMPTY)}));
                this.getChildren().setAll((Object[])new Node[]{this.headersRegion, this.selectedTabLine});
                this.headersRegion.setPickOnBounds(false);
                this.headersRegion.prefHeightProperty().bind((ObservableValue)this.heightProperty());
                this.rotate.pivotXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ((TabHeader)TabHeaderSkin.this.getSkinnable()).getSide().isHorizontal() ? 0.0 : 1.0, (Observable[])new Observable[]{((TabHeader)TabHeaderSkin.this.getSkinnable()).sideProperty()}));
                this.rotate.pivotYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ((TabHeader)TabHeaderSkin.this.getSkinnable()).getSide().isHorizontal() ? 1.0 : 0.0, (Observable[])new Observable[]{((TabHeader)TabHeaderSkin.this.getSkinnable()).sideProperty()}));
                this.binding = MappedObservableList.create(((TabHeader)TabHeaderSkin.this.getSkinnable()).getTabs(), tab -> {
                    TabHeaderContainer container = new TabHeaderContainer((TabControl.Tab<?>)tab);
                    container.setVisible(true);
                    return container;
                });
                Bindings.bindContent((List)this.headersRegion.getChildren(), this.binding);
            }

            public void setNeedsLayout2(boolean value) {
                this.setNeedsLayout(value);
            }

            private boolean isAnimating() {
                return this.timeline != null && this.timeline.getStatus() == Animation.Status.RUNNING;
            }

            protected void layoutChildren() {
                super.layoutChildren();
                if (TabHeaderSkin.this.isSelectingTab) {
                    this.headersRegion.animateSelectionLine();
                    TabHeaderSkin.this.isSelectingTab = false;
                }
            }

            private final class HeadersRegion
            extends StackPane {
                private SideAction action;
                private final ObjectProperty<Side> side = new SimpleObjectProperty<Side>(){

                    protected void invalidated() {
                        super.invalidated();
                        switch ((Side)this.get()) {
                            case TOP: {
                                HeadersRegion.this.action = new Top();
                                break;
                            }
                            case BOTTOM: {
                                HeadersRegion.this.action = new Bottom();
                                break;
                            }
                            case LEFT: {
                                HeadersRegion.this.action = new Left();
                                break;
                            }
                            case RIGHT: {
                                HeadersRegion.this.action = new Right();
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    }
                };

                private HeadersRegion() {
                }

                public Side getSide() {
                    return (Side)this.side.get();
                }

                public ObjectProperty<Side> sideProperty() {
                    return this.side;
                }

                public void setSide(Side side) {
                    this.side.set((Object)side);
                }

                protected double computePrefWidth(double height) {
                    return this.action.computePrefWidth(height);
                }

                protected double computePrefHeight(double width) {
                    return this.action.computePrefHeight(width);
                }

                protected void layoutChildren() {
                    this.action.layoutChildren();
                }

                protected void animateSelectionLine() {
                    this.action.animateSelectionLine();
                }

                private abstract class SideAction {
                    private SideAction() {
                    }

                    abstract double computePrefWidth(double var1);

                    abstract double computePrefHeight(double var1);

                    void layoutChildren() {
                        if (TabHeaderSkin.this.isSelectingTab) {
                            this.animateSelectionLine();
                            TabHeaderSkin.this.isSelectingTab = false;
                        }
                    }

                    abstract void animateSelectionLine();
                }

                private final class Right
                extends Vertical {
                    private Right() {
                    }

                    @Override
                    public void layoutChildren() {
                        super.layoutChildren();
                        double headerWidth = HeadersRegion.this.snapSize(HeadersRegion.this.prefWidth(-1.0));
                        double tabStartY = 0.0;
                        for (Node node : HeadersRegion.this.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer child = (TabHeaderContainer)node;
                            double w = HeadersRegion.this.snapSize(child.prefWidth(-1.0));
                            double h = HeadersRegion.this.snapSize(child.prefHeight(-1.0));
                            child.resize(w, h);
                            child.relocate(HeadersRegion.this.snappedLeftInset(), tabStartY);
                            tabStartY += h;
                        }
                        HeaderContainer.this.selectedTabLine.resizeRelocate(0.0, 0.0, HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                    }
                }

                private final class Left
                extends Vertical {
                    private Left() {
                    }

                    @Override
                    public void layoutChildren() {
                        super.layoutChildren();
                        double headerWidth = HeadersRegion.this.snapSize(HeadersRegion.this.prefWidth(-1.0));
                        double tabStartY = 0.0;
                        for (Node node : HeadersRegion.this.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer child = (TabHeaderContainer)node;
                            double w = HeadersRegion.this.snapSize(child.prefWidth(-1.0));
                            double h = HeadersRegion.this.snapSize(child.prefHeight(-1.0));
                            child.resize(w, h);
                            child.relocate(headerWidth - w - HeadersRegion.this.snappedRightInset(), tabStartY);
                            tabStartY += h;
                        }
                        HeaderContainer.this.selectedTabLine.resizeRelocate(headerWidth - HeaderContainer.this.selectedTabLine.prefWidth(-1.0), 0.0, HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                    }
                }

                private abstract class Vertical
                extends SideAction {
                    private Vertical() {
                    }

                    @Override
                    public double computePrefWidth(double height) {
                        double width = 0.0;
                        for (Node child : HeadersRegion.this.getChildren()) {
                            if (!(child instanceof TabHeaderContainer) || !child.isVisible()) continue;
                            width = Math.max(width, child.prefWidth(height));
                        }
                        return HeadersRegion.this.snapSize(width) + HeadersRegion.this.snappedLeftInset() + HeadersRegion.this.snappedRightInset();
                    }

                    @Override
                    public double computePrefHeight(double width) {
                        double height = 0.0;
                        for (Node child : HeadersRegion.this.getChildren()) {
                            if (!(child instanceof TabHeaderContainer) || !child.isVisible()) continue;
                            height += child.prefHeight(width);
                        }
                        return HeadersRegion.this.snapSize(height) + HeadersRegion.this.snappedTopInset() + HeadersRegion.this.snappedBottomInset();
                    }

                    private void runTimeline(double newTransY, double newHeight) {
                        double lineHeight = HeaderContainer.this.selectedTabLine.prefHeight(-1.0);
                        if (HeaderContainer.this.isAnimating()) {
                            HeaderContainer.this.timeline.stop();
                            double tempScaleY = HeaderContainer.this.scale.getY();
                            if (HeaderContainer.this.rotate.getAngle() != 0.0) {
                                HeaderContainer.this.rotate.setAngle(0.0);
                                double tempHeight = tempScaleY * lineHeight;
                                HeaderContainer.this.selectedTabLine.setTranslateY(HeaderContainer.this.selectedTabLine.getTranslateY() - tempHeight);
                            }
                        }
                        double oldScaleY = HeaderContainer.this.scale.getY();
                        double oldHeight = lineHeight * oldScaleY;
                        double oldTransY = HeaderContainer.this.selectedTabLine.getTranslateY();
                        double newScaleY = newHeight * oldScaleY / oldHeight;
                        HeaderContainer.this.selectedTabLineOffset = newTransY;
                        double transDiff = newTransY - oldTransY;
                        if (transDiff < 0.0) {
                            HeaderContainer.this.selectedTabLine.setTranslateY(HeaderContainer.this.selectedTabLine.getTranslateY() + oldHeight);
                            newTransY += newHeight;
                            HeaderContainer.this.rotate.setAngle(180.0);
                        }
                        HeaderContainer.this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)HeaderContainer.this.selectedTabLine.translateYProperty(), (Object)HeaderContainer.this.selectedTabLine.getTranslateY(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)1.24), new KeyValue[]{new KeyValue((WritableValue)HeaderContainer.this.scale.yProperty(), (Object)newScaleY, Interpolator.EASE_BOTH), new KeyValue((WritableValue)HeaderContainer.this.selectedTabLine.translateYProperty(), (Object)newTransY, Interpolator.EASE_BOTH)})});
                        HeaderContainer.this.timeline.setOnFinished(finish -> {
                            if (HeaderContainer.this.rotate.getAngle() != 0.0) {
                                HeaderContainer.this.rotate.setAngle(0.0);
                                HeaderContainer.this.selectedTabLine.setTranslateY(HeaderContainer.this.selectedTabLine.getTranslateY() - newHeight);
                            }
                        });
                        HeaderContainer.this.timeline.play();
                    }

                    @Override
                    public void animateSelectionLine() {
                        double offset = 0.0;
                        double selectedTabOffset = 0.0;
                        double selectedTabHeight = 0.0;
                        for (Node node : HeaderContainer.this.headersRegion.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer tabHeader = (TabHeaderContainer)node;
                            double tabHeaderPrefHeight = HeadersRegion.this.snapSize(tabHeader.prefHeight(-1.0));
                            if (TabHeaderSkin.this.selectedTab != null && TabHeaderSkin.this.selectedTab.equals(tabHeader.tab)) {
                                selectedTabOffset = offset;
                                selectedTabHeight = tabHeaderPrefHeight;
                                break;
                            }
                            offset += tabHeaderPrefHeight;
                        }
                        this.runTimeline(selectedTabOffset, selectedTabHeight);
                    }
                }

                private final class Bottom
                extends Horizontal {
                    private Bottom() {
                    }

                    @Override
                    public void layoutChildren() {
                        super.layoutChildren();
                        double headerHeight = HeadersRegion.this.snapSize(HeadersRegion.this.prefHeight(-1.0));
                        double tabStartX = 0.0;
                        for (Node node : HeadersRegion.this.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer child = (TabHeaderContainer)node;
                            double w = HeadersRegion.this.snapSize(child.prefWidth(-1.0));
                            double h = HeadersRegion.this.snapSize(child.prefHeight(-1.0));
                            child.resize(w, h);
                            child.relocate(tabStartX, HeadersRegion.this.snappedTopInset());
                            tabStartX += w;
                        }
                        HeaderContainer.this.selectedTabLine.resizeRelocate(0.0, 0.0, HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                    }
                }

                private final class Top
                extends Horizontal {
                    private Top() {
                    }

                    @Override
                    public void layoutChildren() {
                        super.layoutChildren();
                        double headerHeight = HeadersRegion.this.snapSize(HeadersRegion.this.prefHeight(-1.0));
                        double tabStartX = 0.0;
                        for (Node node : HeadersRegion.this.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer child = (TabHeaderContainer)node;
                            double w = HeadersRegion.this.snapSize(child.prefWidth(-1.0));
                            double h = HeadersRegion.this.snapSize(child.prefHeight(-1.0));
                            child.resize(w, h);
                            child.relocate(tabStartX, headerHeight - h - HeadersRegion.this.snappedBottomInset());
                            tabStartX += w;
                        }
                        HeaderContainer.this.selectedTabLine.resizeRelocate(0.0, headerHeight - HeaderContainer.this.selectedTabLine.prefHeight(-1.0), HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), HeadersRegion.this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                    }
                }

                private abstract class Horizontal
                extends SideAction {
                    private Horizontal() {
                    }

                    @Override
                    public double computePrefWidth(double height) {
                        double width = 0.0;
                        for (Node child : HeadersRegion.this.getChildren()) {
                            if (!(child instanceof TabHeaderContainer) || !child.isVisible()) continue;
                            width += child.prefWidth(height);
                        }
                        return HeadersRegion.this.snapSize(width) + HeadersRegion.this.snappedLeftInset() + HeadersRegion.this.snappedRightInset();
                    }

                    @Override
                    public double computePrefHeight(double width) {
                        double height = 0.0;
                        for (Node child : HeadersRegion.this.getChildren()) {
                            if (!(child instanceof TabHeaderContainer) || !child.isVisible()) continue;
                            height = Math.max(height, child.prefHeight(width));
                        }
                        return HeadersRegion.this.snapSize(height) + HeadersRegion.this.snappedTopInset() + HeadersRegion.this.snappedBottomInset();
                    }

                    private void runTimeline(double newTransX, double newWidth) {
                        double lineWidth = HeaderContainer.this.selectedTabLine.prefWidth(-1.0);
                        if (HeaderContainer.this.isAnimating()) {
                            HeaderContainer.this.timeline.stop();
                            double tempScaleX = HeaderContainer.this.scale.getX();
                            if (HeaderContainer.this.rotate.getAngle() != 0.0) {
                                HeaderContainer.this.rotate.setAngle(0.0);
                                double tempWidth = tempScaleX * lineWidth;
                                HeaderContainer.this.selectedTabLine.setTranslateX(HeaderContainer.this.selectedTabLine.getTranslateX() - tempWidth);
                            }
                        }
                        double oldScaleX = HeaderContainer.this.scale.getX();
                        double oldWidth = lineWidth * oldScaleX;
                        double oldTransX = HeaderContainer.this.selectedTabLine.getTranslateX();
                        double newScaleX = newWidth * oldScaleX / oldWidth;
                        HeaderContainer.this.selectedTabLineOffset = newTransX;
                        double transDiff = newTransX - oldTransX;
                        if (transDiff < 0.0) {
                            HeaderContainer.this.selectedTabLine.setTranslateX(HeaderContainer.this.selectedTabLine.getTranslateX() + oldWidth);
                            newTransX += newWidth;
                            HeaderContainer.this.rotate.setAngle(180.0);
                        }
                        HeaderContainer.this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)HeaderContainer.this.selectedTabLine.translateXProperty(), (Object)HeaderContainer.this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.24), new KeyValue[]{new KeyValue((WritableValue)HeaderContainer.this.scale.xProperty(), (Object)newScaleX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)HeaderContainer.this.selectedTabLine.translateXProperty(), (Object)newTransX, Interpolator.EASE_BOTH)})});
                        HeaderContainer.this.timeline.setOnFinished(finish -> {
                            if (HeaderContainer.this.rotate.getAngle() != 0.0) {
                                HeaderContainer.this.rotate.setAngle(0.0);
                                HeaderContainer.this.selectedTabLine.setTranslateX(HeaderContainer.this.selectedTabLine.getTranslateX() - newWidth);
                            }
                        });
                        HeaderContainer.this.timeline.play();
                    }

                    @Override
                    public void animateSelectionLine() {
                        double offset = 0.0;
                        double selectedTabOffset = 0.0;
                        double selectedTabWidth = 0.0;
                        for (Node node : HeaderContainer.this.headersRegion.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer tabHeader = (TabHeaderContainer)node;
                            double tabHeaderPrefWidth = HeadersRegion.this.snapSize(tabHeader.prefWidth(-1.0));
                            if (TabHeaderSkin.this.selectedTab != null && TabHeaderSkin.this.selectedTab.equals(tabHeader.tab)) {
                                selectedTabOffset = offset;
                                selectedTabWidth = tabHeaderPrefWidth;
                                break;
                            }
                            offset += tabHeaderPrefWidth;
                        }
                        this.runTimeline(selectedTabOffset, selectedTabWidth);
                    }
                }
            }
        }

        protected class TabHeaderContainer
        extends StackPane {
            private final TabControl.Tab<?> tab;
            private final Label tabText;
            private final BorderPane inner;
            private final JFXRippler rippler;

            public TabHeaderContainer(TabControl.Tab<?> tab) {
                this.tab = tab;
                this.tabText = new Label();
                this.tabText.textProperty().bind((ObservableValue)tab.textProperty());
                this.tabText.getStyleClass().add((Object)"tab-label");
                this.inner = new BorderPane();
                this.inner.setCenter((Node)this.tabText);
                this.inner.getStyleClass().add((Object)"tab-container");
                this.rippler = new JFXRippler((Node)this.inner, JFXRippler.RipplerPos.FRONT);
                this.rippler.getStyleClass().add((Object)"tab-rippler");
                this.rippler.setRipplerFill((Paint)TabHeaderSkin.this.ripplerColor);
                this.getChildren().setAll((Object[])new Node[]{this.rippler});
                FXUtils.onChangeAndOperate(tab.selectedProperty(), selected -> this.inner.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, selected.booleanValue()));
                FXUtils.onClicked((Node)this, () -> {
                    this.setOpacity(1.0);
                    ((TabHeader)TabHeaderSkin.this.getSkinnable()).getSelectionModel().select((Object)tab);
                });
            }
        }
    }
}

