/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class FileSaver
extends Thread {
    private static final Pair<Path, String> SHUTDOWN = Pair.pair(null, null);
    private static final BlockingQueue<Pair<Path, String>> queue = new LinkedBlockingQueue<Pair<Path, String>>();
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final ReentrantLock runningLock = new ReentrantLock();
    private static volatile boolean shutdown = false;
    private boolean stopped = false;

    private static void doSave(Map<Path, String> map) {
        for (Map.Entry<Path, String> entry : map.entrySet()) {
            FileSaver.saveSync(entry.getKey(), entry.getValue());
        }
    }

    public static void save(Path file, String content) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(content);
        ShutdownHook.ensureInstalled();
        queue.add(Pair.pair(file, content));
        if (running.compareAndSet(false, true)) {
            new FileSaver().start();
        }
    }

    public static void saveSync(Path file, String content) {
        Logger.LOG.info("Saving file " + String.valueOf(file));
        try {
            FileUtils.saveSafely(file, content);
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to save " + String.valueOf(file), e);
        }
    }

    public static void shutdown() {
        shutdown = true;
        queue.add(SHUTDOWN);
    }

    private FileSaver() {
        super("FileSaver");
    }

    private void stopCurrentSaver() {
        if (!this.stopped) {
            this.stopped = true;
            running.set(false);
        }
    }

    @Override
    public void run() {
        runningLock.lock();
        try {
            HashMap<Path, String> map = new HashMap<Path, String>();
            ArrayList buffer = new ArrayList();
            while (!this.stopped) {
                if (shutdown) {
                    this.stopCurrentSaver();
                } else {
                    Pair<Path, String> head = queue.poll(30L, TimeUnit.SECONDS);
                    if (head == null || head == SHUTDOWN) {
                        this.stopCurrentSaver();
                    } else {
                        map.put(head.getKey(), head.getValue());
                        Thread.sleep(200L);
                    }
                }
                while (queue.drainTo(buffer) > 0) {
                    for (Pair pair : buffer) {
                        if (pair == SHUTDOWN) {
                            this.stopCurrentSaver();
                            continue;
                        }
                        map.put((Path)pair.getKey(), (String)pair.getValue());
                    }
                    buffer.clear();
                }
                FileSaver.doSave(map);
                map.clear();
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError("This thread cannot be interrupted", e);
        }
        finally {
            runningLock.unlock();
        }
    }

    private static final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        static void ensureInstalled() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileSaver.shutdown();
            runningLock.lock();
            try {
                HashMap<Path, String> map = new HashMap<Path, String>();
                for (Pair pair : queue) {
                    if (pair == SHUTDOWN) continue;
                    map.put((Path)pair.getKey(), (String)pair.getValue());
                }
                FileSaver.doSave(map);
            }
            finally {
                runningLock.unlock();
            }
        }

        static {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
    }
}

