/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glavo.pci.ids.internal.ArgumentValidator;
import org.glavo.pci.ids.model.Device;
import org.glavo.pci.ids.model.DeviceClass;
import org.glavo.pci.ids.model.DeviceSubclass;
import org.glavo.pci.ids.model.ProgramInterface;
import org.glavo.pci.ids.model.Subsystem;
import org.glavo.pci.ids.model.Vendor;

public final class DatabaseFileParser {
    private final Pattern VENDOR_PATTERN = Pattern.compile("^([0-9a-f]{4})\\s+(.+)$");
    private final Pattern DEVICE_PATTERN = Pattern.compile("^\\t([0-9a-f]{4})\\s+(.+)$");
    private final Pattern SUBSYS_PATTERN = Pattern.compile("^\\t\\t([0-9a-f]{4})\\s([0-9a-f]{4})\\s+(.+)$");
    private final Pattern DEVCLASS_PATTERN = Pattern.compile("^C\\s([0-9a-f]{2})\\s+(.+)$");
    private final Pattern SUBCLASS_PATTERN = Pattern.compile("^\\t([0-9a-f]{2})\\s+(.+)$");
    private final Pattern PROGIFACE_PATTERN = Pattern.compile("^\\t\\t([0-9a-f]{2})\\s+(.+)$");
    private String currentComment = null;

    public void parseDatabaseFile(BufferedReader reader, Map<Integer, Vendor> vendorDb, Map<Integer, DeviceClass> deviceClassDb) throws IOException {
        ArgumentValidator.requireNonNull(reader, "PCI IDs database InputStream");
        try {
            Vendor currentVendor = null;
            Device currentDevice = null;
            DeviceClass currentClass = null;
            DeviceSubclass currentSubclass = null;
            String line = reader.readLine();
            LineType previousLineType = null;
            while (line != null) {
                if (line.trim().isEmpty()) {
                    this.currentComment = null;
                    line = reader.readLine();
                    continue;
                }
                switch (this.determineLineType(line, previousLineType).ordinal()) {
                    case 0: {
                        if (this.currentComment != null) {
                            this.currentComment = this.currentComment + "\n" + line.substring(1).trim();
                            break;
                        }
                        this.currentComment = line.substring(1).trim();
                        break;
                    }
                    case 1: {
                        previousLineType = LineType.DEVICE;
                        if (currentDevice != null) {
                            if (currentVendor == null) {
                                throw new IOException("Encountered unexpected device line");
                            }
                            currentVendor.addDevice(currentDevice);
                        }
                        currentDevice = this.parseDeviceLine(line);
                        break;
                    }
                    case 5: {
                        previousLineType = LineType.SUBSYSTEM;
                        if (currentDevice == null) {
                            throw new IOException("Encountered unexpected subsystem line");
                        }
                        currentDevice.addSubsystem(this.parseSubsystemLine(line));
                        break;
                    }
                    case 6: {
                        previousLineType = LineType.VENDOR;
                        if (currentVendor != null) {
                            if (currentDevice != null) {
                                currentVendor.addDevice(currentDevice);
                                currentDevice = null;
                            }
                            vendorDb.put(currentVendor.getId(), currentVendor);
                        }
                        currentVendor = this.parseVendorLine(line);
                        break;
                    }
                    case 2: {
                        previousLineType = LineType.DEVICE_CLASS;
                        if (currentClass != null) {
                            if (currentSubclass != null) {
                                currentClass.addSubclass(currentSubclass);
                                currentSubclass = null;
                            }
                            deviceClassDb.put(currentClass.getId(), currentClass);
                        }
                        currentClass = this.parseDeviceClassLine(line);
                        break;
                    }
                    case 3: {
                        previousLineType = LineType.DEVICE_SUBCLASS;
                        if (currentSubclass != null) {
                            if (currentClass == null) {
                                throw new IOException("Encountered unexpected device subclass line");
                            }
                            currentClass.addSubclass(currentSubclass);
                        }
                        currentSubclass = this.parseDeviceSubclassLine(line);
                        break;
                    }
                    case 4: {
                        previousLineType = LineType.PROGRAM_INTERFACE;
                        if (currentSubclass == null) {
                            throw new IOException("Encountered unexpected program interface line");
                        }
                        currentSubclass.addProgramInterface(this.parseProgramInterfaceLine(line));
                        break;
                    }
                    default: {
                        throw new IOException("Encountered invalid line format in database file");
                    }
                }
                line = reader.readLine();
            }
            if (currentVendor != null) {
                if (currentDevice != null) {
                    currentVendor.addDevice(currentDevice);
                }
                vendorDb.put(currentVendor.getId(), currentVendor);
            }
            if (currentClass != null) {
                if (currentSubclass != null) {
                    currentClass.addSubclass(currentSubclass);
                }
                deviceClassDb.put(currentClass.getId(), currentClass);
            }
        }
        catch (IOException | RuntimeException ex) {
            throw new IOException("Error while parsing database file", ex);
        }
    }

    Vendor parseVendorLine(String line) throws IOException {
        Matcher m = this.VENDOR_PATTERN.matcher(line);
        if (m.matches()) {
            int id = Integer.parseInt(m.group(1), 16);
            String name = m.group(2);
            Vendor rv = new Vendor(id, name, this.currentComment);
            this.currentComment = null;
            return rv;
        }
        throw new IOException("Unable to process vendor line: [" + line + "]");
    }

    Device parseDeviceLine(String line) throws IOException {
        Matcher m = this.DEVICE_PATTERN.matcher(line);
        if (m.matches()) {
            int id = Integer.parseInt(m.group(1), 16);
            String name = m.group(2);
            Device rv = new Device(id, name, this.currentComment);
            this.currentComment = null;
            return rv;
        }
        throw new IOException("Unable to process device line: [" + line + "]");
    }

    Subsystem parseSubsystemLine(String line) throws IOException {
        Matcher m = this.SUBSYS_PATTERN.matcher(line);
        if (m.matches()) {
            int id = Integer.parseInt(m.group(2), 16);
            String name = m.group(3);
            int vendorId = Integer.parseInt(m.group(1), 16);
            Subsystem rv = new Subsystem(id, name, this.currentComment, vendorId);
            this.currentComment = null;
            return rv;
        }
        throw new IOException("Unable to process subsystem line: [" + line + "]");
    }

    DeviceClass parseDeviceClassLine(String line) throws IOException {
        Matcher m = this.DEVCLASS_PATTERN.matcher(line);
        if (m.matches()) {
            int id = Integer.parseInt(m.group(1), 16);
            String name = m.group(2);
            DeviceClass rv = new DeviceClass(id, name, this.currentComment);
            this.currentComment = null;
            return rv;
        }
        throw new IOException("Unable to process device class line: [" + line + "]");
    }

    DeviceSubclass parseDeviceSubclassLine(String line) throws IOException {
        Matcher m = this.SUBCLASS_PATTERN.matcher(line);
        if (m.matches()) {
            int id = Integer.parseInt(m.group(1), 16);
            String name = m.group(2);
            DeviceSubclass rv = new DeviceSubclass(id, name, this.currentComment);
            this.currentComment = null;
            return rv;
        }
        throw new IOException("Unable to process device subclass line: [" + line + "]");
    }

    ProgramInterface parseProgramInterfaceLine(String line) throws IOException {
        Matcher m = this.PROGIFACE_PATTERN.matcher(line);
        if (m.matches()) {
            String id = m.group(1);
            String name = m.group(2);
            ProgramInterface rv = new ProgramInterface(Integer.parseInt(id, 16), name, this.currentComment);
            this.currentComment = null;
            return rv;
        }
        throw new IOException("Unable to process program interface line: [" + line + "]");
    }

    LineType determineLineType(String line, LineType previous) {
        if (line.startsWith("#")) {
            return LineType.COMMENT;
        }
        if (line.startsWith("C")) {
            return LineType.DEVICE_CLASS;
        }
        if (line.startsWith("\t\t")) {
            if (previous == LineType.DEVICE || previous == LineType.SUBSYSTEM) {
                return LineType.SUBSYSTEM;
            }
            if (previous == LineType.DEVICE_SUBCLASS || previous == LineType.PROGRAM_INTERFACE) {
                return LineType.PROGRAM_INTERFACE;
            }
            throw new IllegalArgumentException("Unexpected previous line type: " + (Object)((Object)previous));
        }
        if (line.startsWith("\t")) {
            if (previous == LineType.VENDOR || previous == LineType.DEVICE || previous == LineType.SUBSYSTEM) {
                return LineType.DEVICE;
            }
            if (previous == LineType.DEVICE_CLASS || previous == LineType.DEVICE_SUBCLASS || previous == LineType.PROGRAM_INTERFACE) {
                return LineType.DEVICE_SUBCLASS;
            }
            throw new IllegalArgumentException("Unexpected previous line type: " + (Object)((Object)previous));
        }
        return LineType.VENDOR;
    }

    static enum LineType {
        COMMENT,
        DEVICE,
        DEVICE_CLASS,
        DEVICE_SUBCLASS,
        PROGRAM_INTERFACE,
        SUBSYSTEM,
        VENDOR;

    }
}

