/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class MultiMCComponents {
    private static final Map<String, String> INSTALLER_PROFILE = new ConcurrentHashMap<String, String>();
    private static final Map<String, LibraryAnalyzer.LibraryType> ID_TYPE;
    private static final Map<LibraryAnalyzer.LibraryType, String> TYPE_ID;
    private static final Collection<Map.Entry<String, LibraryAnalyzer.LibraryType>> PAIRS;

    private MultiMCComponents() {
    }

    public static void setImplementation(String implementation) {
        INSTALLER_PROFILE.put("Implementation", implementation);
    }

    public static String getInstallerProfile() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : INSTALLER_PROFILE.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        if (builder.length() != 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String getComponent(LibraryAnalyzer.LibraryType type) {
        return TYPE_ID.get((Object)type);
    }

    public static LibraryAnalyzer.LibraryType getComponent(String type) {
        return ID_TYPE.get(type);
    }

    public static Collection<Map.Entry<String, LibraryAnalyzer.LibraryType>> getPairs() {
        return PAIRS;
    }

    public static URI getMetaURL(String componentID, String version, String mcVersion) {
        if (version == null) {
            switch (componentID) {
                case "org.lwjgl": {
                    version = "2.9.1";
                    break;
                }
                case "org.lwjgl3": {
                    version = "3.1.2";
                    break;
                }
                case "net.fabricmc.intermediary": 
                case "org.quiltmc.hashed": {
                    version = mcVersion;
                }
            }
        }
        return NetworkUtils.toURI(String.format("https://meta.multimc.org/v1/%s/%s.json", componentID, version));
    }

    static {
        INSTALLER_PROFILE.put("Patches", "recursive install, fabric & quilt intermediary");
        if (new String(Base64.getDecoder().decode("b3JnLmphY2todWFuZy5obWNsLm1vZC5tdWx0aW1jLk11bHRpTUNDb21wb25lbnRz"), StandardCharsets.UTF_8).equals(MultiMCComponents.class.getName())) {
            INSTALLER_PROFILE.put("Implementation", "Probably vanilla. Class location is not modified (org.jackhuang.hmcl.mod.multimc.MultiMCComponents).");
        } else {
            INSTALLER_PROFILE.put("Implementation", "Not vanilla. Class location is " + MultiMCComponents.class.getName());
        }
        ID_TYPE = new HashMap<String, LibraryAnalyzer.LibraryType>();
        ID_TYPE.put("net.minecraft", LibraryAnalyzer.LibraryType.MINECRAFT);
        ID_TYPE.put("net.minecraftforge", LibraryAnalyzer.LibraryType.FORGE);
        ID_TYPE.put("net.neoforged", LibraryAnalyzer.LibraryType.NEO_FORGE);
        ID_TYPE.put("com.mumfrey.liteloader", LibraryAnalyzer.LibraryType.LITELOADER);
        ID_TYPE.put("net.fabricmc.fabric-loader", LibraryAnalyzer.LibraryType.FABRIC);
        ID_TYPE.put("org.quiltmc.quilt-loader", LibraryAnalyzer.LibraryType.QUILT);
        TYPE_ID = ID_TYPE.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        PAIRS = Collections.unmodifiableCollection(ID_TYPE.entrySet());
        if (TYPE_ID.isEmpty()) {
            throw new AssertionError((Object)"Please make sure TYPE_ID and PAIRS is initialized after ID_TYPE!");
        }
    }
}

