/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public final class TypeUtils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private TypeUtils() {
        throw new UnsupportedOperationException();
    }

    private static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Class<?> rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        Type[] upperBounds;
        if (bound instanceof WildcardType) {
            WildcardType w = (WildcardType)bound;
            upperBounds = w.getUpperBounds();
        } else {
            upperBounds = new Type[]{bound};
        }
        return new WildcardTypeImpl(upperBounds, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        Type[] lowerBounds;
        if (bound instanceof WildcardType) {
            WildcardType w = (WildcardType)bound;
            lowerBounds = w.getLowerBounds();
        } else {
            lowerBounds = new Type[]{bound};
        }
        return new WildcardTypeImpl(new Type[]{Object.class}, lowerBounds);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(TypeUtils.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), (Class)p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            TypeUtils.checkArgument(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            Type componentType = g.getGenericComponentType();
            return Array.newInstance(TypeUtils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            Type[] bounds = w.getUpperBounds();
            assert (bounds.length == 1);
            return TypeUtils.getRawType(bounds[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + String.valueOf(type) + "> is of type " + className);
    }

    private static boolean equal(Object a, Object b) {
        return Objects.equals(a, b);
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            ParameterizedType pa = (ParameterizedType)a;
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pb = (ParameterizedType)b;
            return TypeUtils.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            GenericArrayType ga = (GenericArrayType)a;
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType gb = (GenericArrayType)b;
            return TypeUtils.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            WildcardType wa = (WildcardType)a;
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            TypeVariable va = (TypeVariable)a;
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable vb = (TypeVariable)b;
            return Objects.equals(va.getGenericDeclaration(), vb.getGenericDeclaration()) && va.getName().equals(vb.getName());
        }
        return false;
    }

    public static String typeToString(Type type) {
        String string;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            string = clazz.getName();
        } else {
            string = type.toString();
        }
        return string;
    }

    public static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> supertype) {
        if (supertype == rawType) {
            return context;
        }
        if (supertype.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == supertype) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!supertype.isAssignableFrom(interfaces[i])) continue;
                return TypeUtils.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], supertype);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == supertype) {
                    return rawType.getGenericSuperclass();
                }
                if (supertype.isAssignableFrom(rawSupertype)) {
                    return TypeUtils.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, supertype);
                }
                rawType = rawSupertype;
            }
        }
        return supertype;
    }

    public static Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
        if (context instanceof WildcardType) {
            WildcardType w = (WildcardType)context;
            Type[] bounds = w.getUpperBounds();
            assert (bounds.length == 1);
            context = bounds[0];
        }
        TypeUtils.checkArgument(supertype.isAssignableFrom(contextRawType));
        return TypeUtils.resolve(context, contextRawType, TypeUtils.getGenericSupertype(context, contextRawType, supertype));
    }

    public static Type getArrayComponentType(Type array) {
        Type type;
        if (array instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)array;
            type = g.getGenericComponentType();
        } else {
            type = ((Class)array).getComponentType();
        }
        return type;
    }

    public static Type getCollectionElementType(Type context, Class<?> contextRawType) {
        Type collectionType = TypeUtils.getSupertype(context, contextRawType, Collection.class);
        if (collectionType instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)collectionType;
            return p.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Type[] getMapKeyAndValueTypes(Type context, Class<?> contextRawType) {
        if (Properties.class.isAssignableFrom(contextRawType)) {
            return new Type[]{String.class, String.class};
        }
        Type mapType = TypeUtils.getSupertype(context, contextRawType, Map.class);
        if (mapType instanceof ParameterizedType) {
            ParameterizedType mapParameterizedType = (ParameterizedType)mapType;
            return mapParameterizedType.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        return TypeUtils.resolve(context, contextRawType, toResolve, new HashMap());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Map<TypeVariable<?>, Type> visitedTypeVariables) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            resolving = null;
                            while (toResolve instanceof TypeVariable) {
                                typeVariable = (TypeVariable)toResolve;
                                previouslyResolved = visitedTypeVariables.get(typeVariable);
                                if (previouslyResolved != null) {
                                    return previouslyResolved == Void.TYPE ? toResolve : previouslyResolved;
                                }
                                visitedTypeVariables.put(typeVariable, Void.TYPE);
                                if (resolving == null) {
                                    resolving = typeVariable;
                                }
                                if ((toResolve = TypeUtils.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) continue;
                                break block8;
                            }
                            if (!(toResolve instanceof Class) || !(original = (Class)toResolve).isArray()) break block9;
                            componentType /* !! */  = original.getComponentType();
                            toResolve = TypeUtils.equal(componentType /* !! */ , newComponentType = TypeUtils.resolve(context, contextRawType, componentType /* !! */ , visitedTypeVariables)) != false ? original : TypeUtils.arrayOf(newComponentType);
                            break block8;
                        }
                        if (!(toResolve instanceof GenericArrayType)) break block10;
                        original = (GenericArrayType)toResolve;
                        componentType /* !! */  = original.getGenericComponentType();
                        toResolve = TypeUtils.equal(componentType /* !! */ , newComponentType = TypeUtils.resolve(context, contextRawType, componentType /* !! */ , visitedTypeVariables)) != false ? original : TypeUtils.arrayOf(newComponentType);
                        break block8;
                    }
                    if (!(toResolve instanceof ParameterizedType)) break block11;
                    original = (ParameterizedType)toResolve;
                    ownerType = original.getOwnerType();
                    newOwnerType = TypeUtils.resolve(context, contextRawType, ownerType, visitedTypeVariables);
                    ownerChanged = TypeUtils.equal(newOwnerType, ownerType) == false;
                    args = original.getActualTypeArguments();
                    argsChanged = false;
                    length = args.length;
                    for (t = 0; t < length; ++t) {
                        resolvedTypeArgument = TypeUtils.resolve(context, contextRawType, args[t], visitedTypeVariables);
                        if (TypeUtils.equal(resolvedTypeArgument, args[t])) continue;
                        if (!argsChanged) {
                            args = (Type[])args.clone();
                            argsChanged = true;
                        }
                        args[t] = resolvedTypeArgument;
                    }
                    toResolve = ownerChanged != false || argsChanged != false ? TypeUtils.newParameterizedTypeWithOwner(newOwnerType, (Class)original.getRawType(), args) : original;
                    break block8;
                }
                if (!(toResolve instanceof WildcardType)) break block8;
                original = (WildcardType)toResolve;
                originalLowerBound = original.getLowerBounds();
                originalUpperBound = original.getUpperBounds();
                if (originalLowerBound.length != 1) break block12;
                lowerBound = TypeUtils.resolve(context, contextRawType, originalLowerBound[0], visitedTypeVariables);
                if (lowerBound == originalLowerBound[0]) ** GOTO lbl-1000
                toResolve = TypeUtils.supertypeOf(lowerBound);
                break block8;
            }
            if (originalUpperBound.length == 1 && (upperBound = TypeUtils.resolve(context, contextRawType, originalUpperBound[0], visitedTypeVariables)) != originalUpperBound[0]) {
                toResolve = TypeUtils.subtypeOf(upperBound);
            } else lbl-1000:
            // 2 sources

            {
                toResolve = original;
            }
        }
        if (resolving != null) {
            visitedTypeVariables.put(resolving, toResolve);
        }
        return toResolve;
    }

    private static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = TypeUtils.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = TypeUtils.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)declaredBy;
            int index = TypeUtils.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return p.getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static int indexOf(Object[] array, Object toFind) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Class clazz;
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (clazz = (Class)genericDeclaration) : null;
    }

    static void checkNotPrimitive(Type type) {
        Class clazz;
        TypeUtils.checkArgument(!(type instanceof Class) || !(clazz = (Class)type).isPrimitive());
    }

    public static boolean requiresOwnerType(Type rawType) {
        if (rawType instanceof Class) {
            Class rawTypeAsClass = (Class)rawType;
            return !Modifier.isStatic(rawTypeAsClass.getModifiers()) && rawTypeAsClass.getDeclaringClass() != null;
        }
        return false;
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type ownerType, Class<?> rawType, Type ... typeArguments) {
            Objects.requireNonNull(rawType);
            if (ownerType == null && TypeUtils.requiresOwnerType(rawType)) {
                throw new IllegalArgumentException("Must specify owner type for " + String.valueOf(rawType));
            }
            this.ownerType = ownerType == null ? null : TypeUtils.canonicalize(ownerType);
            this.rawType = TypeUtils.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            int length = this.typeArguments.length;
            for (int t = 0; t < length; ++t) {
                Objects.requireNonNull(this.typeArguments[t]);
                TypeUtils.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = TypeUtils.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type @NotNull [] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        @NotNull
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            ParameterizedType p;
            return other instanceof ParameterizedType && TypeUtils.equals(this, p = (ParameterizedType)other);
        }

        private static int hashCodeOrZero(Object o) {
            return o != null ? o.hashCode() : 0;
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ ParameterizedTypeImpl.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            int length = this.typeArguments.length;
            if (length == 0) {
                return TypeUtils.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (length + 1));
            stringBuilder.append(TypeUtils.typeToString(this.rawType)).append("<").append(TypeUtils.typeToString(this.typeArguments[0]));
            for (int i = 1; i < length; ++i) {
                stringBuilder.append(", ").append(TypeUtils.typeToString(this.typeArguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public GenericArrayTypeImpl(Type componentType) {
            Objects.requireNonNull(componentType);
            this.componentType = TypeUtils.canonicalize(componentType);
        }

        @Override
        @NotNull
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            GenericArrayType g;
            return o instanceof GenericArrayType && TypeUtils.equals(this, g = (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return TypeUtils.typeToString(this.componentType) + "[]";
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            TypeUtils.checkArgument(lowerBounds.length <= 1);
            TypeUtils.checkArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                Objects.requireNonNull(lowerBounds[0]);
                TypeUtils.checkNotPrimitive(lowerBounds[0]);
                TypeUtils.checkArgument(upperBounds[0] == Object.class);
                this.lowerBound = TypeUtils.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                Objects.requireNonNull(upperBounds[0]);
                TypeUtils.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = TypeUtils.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type @NotNull [] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type @NotNull [] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            WildcardType w;
            return other instanceof WildcardType && TypeUtils.equals(this, w = (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + TypeUtils.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + TypeUtils.typeToString(this.upperBound);
        }
    }
}

