/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.modrinth.ModrinthManifest;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public class ModrinthCompletionTask
extends Task<Void> {
    private final DefaultDependencyManager dependency;
    private final DefaultGameRepository repository;
    private final ModManager modManager;
    private final String version;
    private ModrinthManifest manifest;
    private final List<Task<?>> dependencies = new ArrayList();
    private final AtomicBoolean allNameKnown = new AtomicBoolean(true);
    private final AtomicInteger finished = new AtomicInteger(0);
    private final AtomicBoolean notFound = new AtomicBoolean(false);

    public ModrinthCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        this(dependencyManager, version, null);
    }

    public ModrinthCompletionTask(DefaultDependencyManager dependencyManager, String version, ModrinthManifest manifest) {
        this.dependency = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.modManager = this.repository.getModManager(version);
        this.version = version;
        this.manifest = manifest;
        if (manifest == null) {
            try {
                Path manifestFile = this.repository.getVersionRoot(version).resolve("modrinth.index.json");
                if (Files.exists(manifestFile, new LinkOption[0])) {
                    this.manifest = JsonUtils.fromJsonFile(manifestFile, ModrinthManifest.class);
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Unable to read Modrinth modpack manifest.json", e);
            }
        }
        this.setStage("hmcl.modpack.download");
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        if (this.manifest == null) {
            return;
        }
        Path runDirectory = FileUtils.toAbsolute(this.repository.getRunDirectory(this.version));
        Path modsDirectory = runDirectory.resolve("mods");
        for (ModrinthManifest.File file : this.manifest.getFiles()) {
            if (file.getEnv() != null && file.getEnv().getOrDefault("client", "required").equals("unsupported") || file.getDownloads().isEmpty()) continue;
            Path filePath = runDirectory.resolve(file.getPath()).toAbsolutePath().normalize();
            if (!filePath.startsWith(runDirectory)) {
                throw new IOException("Unsecure path: " + file.getPath());
            }
            if (Files.exists(filePath, new LinkOption[0]) || modsDirectory.equals(filePath.getParent()) && this.modManager.hasSimpleMod(FileUtils.getName(filePath))) continue;
            FileDownloadTask task = new FileDownloadTask(file.getDownloads().stream().map(NetworkUtils::toURI).collect(Collectors.toList()), filePath);
            task.setCacheRepository(this.dependency.getCacheRepository());
            task.setCaching(true);
            this.dependencies.add(task.withCounter("hmcl.modpack.download"));
        }
        if (!this.dependencies.isEmpty()) {
            this.getProperties().put("total", this.dependencies.size());
            this.notifyPropertiesChanged();
        }
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (this.notFound.get()) {
            throw new ModpackCompletionException(new FileNotFoundException());
        }
        if (!this.allNameKnown.get() || !this.isDependenciesSucceeded()) {
            throw new ModpackCompletionException();
        }
    }
}

