/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public final class DesktopUtils {
    private static final String[] linuxBrowsers = new String[]{"xdg-open", "google-chrome", "firefox", "microsoft-edge", "opera", "konqueror", "mozilla"};

    public static Path which(String command) {
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        try {
            for (String item : path.split(File.pathSeparator)) {
                try {
                    Path program = Paths.get(item, command);
                    if (!Files.isExecutable(program)) continue;
                    return program.toRealPath(new LinkOption[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void openLink(String link) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        Throwable e1 = null;
        try {
            if (osName.startsWith("windows")) {
                Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", link});
                return;
            }
            if (osName.startsWith("mac") || osName.startsWith("darwin")) {
                Runtime.getRuntime().exec(new String[]{"open", link});
                return;
            }
            for (String browser : linuxBrowsers) {
                Path path = DesktopUtils.which(browser);
                if (path == null) continue;
                try {
                    Runtime.getRuntime().exec(new String[]{path.toString(), link});
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.err.println("No known browser found");
        }
        catch (Throwable e) {
            e1 = e;
        }
        try {
            Desktop.getDesktop().browse(new URI(link));
        }
        catch (Throwable e2) {
            if (e1 != null) {
                e2.addSuppressed(e1);
            }
            e2.printStackTrace(System.err);
        }
    }

    private DesktopUtils() {
    }
}

