/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;

@Immutable
public class ForgeNewInstallProfile
implements Validation {
    private final int spec;
    private final String minecraft;
    private final String json;
    private final String version;
    private final Artifact path;
    private final List<Library> libraries;
    private final List<Processor> processors;
    private final Map<String, Datum> data;

    public ForgeNewInstallProfile(int spec, String minecraft, String json, String version, Artifact path, List<Library> libraries, List<Processor> processors, Map<String, Datum> data) {
        this.spec = spec;
        this.minecraft = minecraft;
        this.json = json;
        this.version = version;
        this.path = path;
        this.libraries = libraries;
        this.processors = processors;
        this.data = data;
    }

    public int getSpec() {
        return this.spec;
    }

    public String getMinecraft() {
        return this.minecraft;
    }

    public String getJson() {
        return this.json;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<Artifact> getPath() {
        return Optional.ofNullable(this.path);
    }

    public List<Library> getLibraries() {
        return this.libraries == null ? Collections.emptyList() : this.libraries;
    }

    public List<Processor> getProcessors() {
        if (this.processors == null) {
            return Collections.emptyList();
        }
        return this.processors.stream().filter(p -> p.isSide("client")).collect(Collectors.toList());
    }

    public Map<String, String> getData() {
        if (this.data == null) {
            return new HashMap<String, String>();
        }
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Datum)e.getValue()).getClient()));
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        if (this.minecraft == null || this.json == null || this.version == null) {
            throw new JsonParseException("ForgeNewInstallProfile is malformed");
        }
    }

    public static class Datum {
        private final String client;

        public Datum(String client) {
            this.client = client;
        }

        public String getClient() {
            return this.client;
        }
    }

    public static class Processor
    implements Validation {
        private final List<String> sides;
        private final Artifact jar;
        private final List<Artifact> classpath;
        private final List<String> args;
        private final Map<String, String> outputs;

        public Processor(List<String> sides, Artifact jar, List<Artifact> classpath, List<String> args, Map<String, String> outputs) {
            this.sides = sides;
            this.jar = jar;
            this.classpath = classpath;
            this.args = args;
            this.outputs = outputs;
        }

        public boolean isSide(String side) {
            return this.sides == null || this.sides.contains(side);
        }

        public Artifact getJar() {
            return this.jar;
        }

        public List<Artifact> getClasspath() {
            return this.classpath == null ? Collections.emptyList() : this.classpath;
        }

        public List<String> getArgs() {
            return this.args == null ? Collections.emptyList() : this.args;
        }

        public Map<String, String> getOutputs() {
            return this.outputs == null ? Collections.emptyMap() : this.outputs;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            if (this.jar == null) {
                throw new JsonParseException("Processor::jar cannot be null");
            }
        }
    }
}

