/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.OAuth;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class OAuthServer
extends NanoHTTPD
implements OAuth.Session {
    private final int port;
    private final CompletableFuture<String> future = new CompletableFuture();
    public static String lastlyOpenedURL;
    private String idToken;

    private OAuthServer(int port) {
        super(port);
        this.port = port;
    }

    @Override
    public String getRedirectURI() {
        return String.format("http://localhost:%d/auth-response", this.port);
    }

    @Override
    public String waitFor() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public String getIdToken() {
        return this.idToken;
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String html;
        if (!"/auth-response".equals(session.getUri())) {
            return OAuthServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/html", "");
        }
        if (session.getMethod() == NanoHTTPD.Method.POST) {
            HashMap<String, String> files = new HashMap<String, String>();
            try {
                session.parseBody(files);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to read post data", e);
                return OAuthServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/html", "");
            }
            catch (NanoHTTPD.ResponseException re) {
                return OAuthServer.newFixedLengthResponse(re.getStatus(), "text/plain", re.getMessage());
            }
        } else if (session.getMethod() != NanoHTTPD.Method.GET) {
            return OAuthServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/html", "");
        }
        String parameters = session.getQueryParameterString();
        Map query = Lang.mapOf(NetworkUtils.parseQuery(parameters));
        if (query.containsKey("code")) {
            this.idToken = (String)query.get("id_token");
            this.future.complete((String)query.get("code"));
        } else {
            Logger.LOG.warning("Error: " + parameters);
            this.future.completeExceptionally(new AuthenticationException("failed to authenticate"));
        }
        try {
            html = IOUtils.readFullyAsString(OAuthServer.class.getResourceAsStream("/assets/microsoft_auth.html")).replace("%lang%", Locale.getDefault().toLanguageTag()).replace("%close-page%", I18n.i18n("account.methods.microsoft.close_page"));
        }
        catch (IOException e) {
            Logger.LOG.error("Failed to load html", e);
            return OAuthServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/html", "");
        }
        Lang.thread(() -> {
            try {
                Thread.sleep(1000L);
                this.stop();
            }
            catch (InterruptedException e) {
                Logger.LOG.error("Failed to sleep for 1 second");
            }
        });
        return OAuthServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/html; charset=UTF-8", html);
    }

    public static class MicrosoftAuthenticationNotSupportedException
    extends AuthenticationException {
    }

    public static class OpenBrowserEvent
    extends Event {
        private final String url;

        public OpenBrowserEvent(Object source, String url) {
            super(source);
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class GrantDeviceCodeEvent
    extends Event {
        private final String userCode;
        private final String verificationUri;

        public GrantDeviceCodeEvent(Object source, String userCode, String verificationUri) {
            super(source);
            this.userCode = userCode;
            this.verificationUri = verificationUri;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public String getVerificationUri() {
            return this.verificationUri;
        }
    }

    public static class Factory
    implements OAuth.Callback {
        public final EventManager<GrantDeviceCodeEvent> onGrantDeviceCode = new EventManager();
        public final EventManager<OpenBrowserEvent> onOpenBrowser = new EventManager();

        @Override
        public OAuth.Session startServer() throws IOException, AuthenticationException {
            if (StringUtils.isBlank(this.getClientId())) {
                throw new MicrosoftAuthenticationNotSupportedException();
            }
            IOException exception = null;
            for (int port : new int[]{29111, 29112, 29113, 29114, 29115}) {
                try {
                    OAuthServer server = new OAuthServer(port);
                    server.start(5000, true);
                    return server;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            throw exception;
        }

        @Override
        public void grantDeviceCode(String userCode, String verificationURI) {
            this.onGrantDeviceCode.fireEvent(new GrantDeviceCodeEvent(this, userCode, verificationURI));
        }

        @Override
        public void openBrowser(String url) throws IOException {
            lastlyOpenedURL = url;
            FXUtils.openLink(url);
            this.onOpenBrowser.fireEvent(new OpenBrowserEvent(this, url));
        }

        @Override
        public String getClientId() {
            return System.getProperty("hmcl.microsoft.auth.id", JarUtils.getAttribute("hmcl.microsoft.auth.id", ""));
        }

        @Override
        public String getClientSecret() {
            return System.getProperty("hmcl.microsoft.auth.secret", JarUtils.getAttribute("hmcl.microsoft.auth.secret", ""));
        }

        @Override
        public boolean isPublicClient() {
            return true;
        }
    }
}

