/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.resourcepack;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.modinfo.PackMcMeta;
import org.jackhuang.hmcl.resourcepack.ResourcepackFile;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class ResourcepackFolder
implements ResourcepackFile {
    private final Path path;
    private final LocalModFile.Description description;
    private final byte @Nullable [] icon;

    public ResourcepackFolder(Path path) {
        byte[] icon;
        this.path = path;
        LocalModFile.Description description = null;
        try {
            description = JsonUtils.fromJsonFile(path.resolve("pack.mcmeta"), PackMcMeta.class).pack().description();
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to parse resourcepack meta", e);
        }
        try {
            icon = Files.readAllBytes(path.resolve("pack.png"));
        }
        catch (IOException e) {
            icon = null;
            Logger.LOG.warning("Failed to read resourcepack icon", e);
        }
        this.icon = icon;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.path.getFileName().toString();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public LocalModFile.Description getDescription() {
        return this.description;
    }

    @Override
    public byte @Nullable [] getIcon() {
        return this.icon;
    }
}

