/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.terracotta.TerracottaNative;
import org.jackhuang.hmcl.terracotta.provider.GeneralProvider;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.terracotta.provider.MacOSProvider;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.i18n.LocalizedText;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OSVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

public final class TerracottaMetadata {
    public static final ITerracottaProvider PROVIDER;
    public static final String PACKAGE_NAME;
    public static final List<Link> PACKAGE_LINKS;
    public static final String FEEDBACK_LINK;
    private static final Pattern LEGACY;
    private static final List<String> RECENT;
    private static final String LATEST;

    private TerracottaMetadata() {
    }

    @Nullable
    private static ProviderContext locateProvider(Config config) {
        String arch = Architecture.SYSTEM_ARCH.getCheckedName();
        return switch (OperatingSystem.CURRENT_OS) {
            case OperatingSystem.WINDOWS -> {
                if (!OperatingSystem.SYSTEM_VERSION.isAtLeast(OSVersion.WINDOWS_10)) {
                    yield null;
                }
                TerracottaNative target = config.of("windows-%s.exe".formatted(arch));
                if (target != null) {
                    yield new ProviderContext(new GeneralProvider(target), "windows", arch);
                }
                yield null;
            }
            case OperatingSystem.LINUX -> {
                TerracottaNative target = config.of("linux-%s".formatted(arch));
                if (target != null) {
                    yield new ProviderContext(new GeneralProvider(target), "linux", arch);
                }
                yield null;
            }
            case OperatingSystem.MACOS -> {
                TerracottaNative installer = config.of("macos-%s.pkg".formatted(arch));
                TerracottaNative binary = config.of("macos-%s".formatted(arch));
                if (installer != null && binary != null) {
                    yield new ProviderContext(new MacOSProvider(installer, binary), "macos", arch);
                }
                yield null;
            }
            default -> null;
        };
    }

    public static void removeLegacyVersionFiles() throws IOException {
        try (DirectoryStream<Path> terracotta = Files.newDirectoryStream(Metadata.DEPENDENCIES_DIRECTORY.resolve("terracotta").toAbsolutePath());){
            for (Path path : terracotta) {
                String name = FileUtils.getName(path);
                if (LATEST.equals(name) || RECENT.contains(name) || !LEGACY.matcher(name).matches()) continue;
                try {
                    FileUtils.deleteDirectory(path);
                }
                catch (IOException e) {
                    Logger.LOG.warning(String.format("Unable to remove legacy terracotta files: %s", path), e);
                }
            }
        }
    }

    public static boolean hasLegacyVersionFiles() throws IOException {
        try (DirectoryStream<Path> terracotta = Files.newDirectoryStream(Metadata.DEPENDENCIES_DIRECTORY.resolve("terracotta").toAbsolutePath());){
            for (Path path : terracotta) {
                String name = FileUtils.getName(path);
                if (LATEST.equals(name) || !RECENT.contains(name) && !LEGACY.matcher(name).matches()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    static {
        Config config;
        FEEDBACK_LINK = NetworkUtils.withQuery("https://docs.hmcl.net/multiplayer/feedback.html", Map.of("v", "v1", "launcher_version", Metadata.VERSION));
        try (InputStream is = TerracottaMetadata.class.getResourceAsStream("/assets/terracotta.json");){
            config = JsonUtils.fromNonNullJsonFully(is, Config.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        LEGACY = Pattern.compile(config.legacy);
        RECENT = config.recent;
        LATEST = config.latest;
        ProviderContext context = TerracottaMetadata.locateProvider(config);
        PROVIDER = context != null ? context.provider() : null;
        String string = PACKAGE_NAME = context != null ? String.format("terracotta-%s-%s-pkg.tar.gz", config.latest, context.branch) : null;
        if (context != null) {
            ArrayList<Link> packageLinks = new ArrayList<Link>(config.links.size());
            for (Link link : config.links) {
                packageLinks.add(new Link(link.description, link.link.replace("${version}", LATEST).replace("${classifier}", context.branch)));
            }
            Collections.shuffle(packageLinks);
            PACKAGE_LINKS = Collections.unmodifiableList(packageLinks);
        } else {
            PACKAGE_LINKS = null;
        }
    }

    private record Config(@SerializedName(value="version_legacy") String legacy, @SerializedName(value="version_recent") List<String> recent, @SerializedName(value="version_latest") String latest, @SerializedName(value="classifiers") Map<String, String> classifiers, @SerializedName(value="downloads") List<String> downloads, @SerializedName(value="downloads_CN") List<String> downloadsCN, @SerializedName(value="links") List<Link> links) {
        @Nullable
        private TerracottaNative of(String classifier) {
            String hash = this.classifiers.get(classifier);
            if (hash == null) {
                return null;
            }
            if (!hash.startsWith("sha256:")) {
                throw new IllegalArgumentException(String.format("Invalid hash value %s for classifier %s.", hash, classifier));
            }
            hash = hash.substring("sha256:".length());
            ArrayList<URI> links = new ArrayList<URI>(this.downloads.size() + this.downloadsCN.size());
            for (String download : LocaleUtils.IS_CHINA_MAINLAND ? Lang.merge(this.downloadsCN, this.downloads) : Lang.merge(this.downloads, this.downloadsCN)) {
                links.add(URI.create(download.replace("${version}", this.latest).replace("${classifier}", classifier)));
            }
            return new TerracottaNative(Collections.unmodifiableList(links), Metadata.DEPENDENCIES_DIRECTORY.resolve(String.format("terracotta/%s/terracotta-%s-%s", this.latest, this.latest, classifier)).toAbsolutePath(), new FileDownloadTask.IntegrityCheck("SHA-256", hash));
        }
    }

    private record ProviderContext(ITerracottaProvider provider, String branch) {
        ProviderContext(ITerracottaProvider provider, String system, String arch) {
            this(provider, system + "-" + arch);
        }
    }

    public record Link(@SerializedName(value="desc") LocalizedText description, String link) {
    }
}

