/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modinfo;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Path;
import kala.compress.archivers.zip.ZipArchiveEntry;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.tree.ZipFileTree;

@Immutable
public final class LiteModMetadata {
    private final String name;
    private final String version;
    private final String mcversion;
    private final String revision;
    private final String author;
    private final String[] classTransformerClasses;
    private final String description;
    private final String modpackName;
    private final String modpackVersion;
    private final String checkUpdateUrl;
    private final String updateURI;

    public LiteModMetadata() {
        this("", "", "", "", "", new String[]{""}, "", "", "", "", "");
    }

    public LiteModMetadata(String name, String version, String mcversion, String revision, String author, String[] classTransformerClasses, String description, String modpackName, String modpackVersion, String checkUpdateUrl, String updateURI) {
        this.name = name;
        this.version = version;
        this.mcversion = mcversion;
        this.revision = revision;
        this.author = author;
        this.classTransformerClasses = classTransformerClasses;
        this.description = description;
        this.modpackName = modpackName;
        this.modpackVersion = modpackVersion;
        this.checkUpdateUrl = checkUpdateUrl;
        this.updateURI = updateURI;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGameVersion() {
        return this.mcversion;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public String[] getClassTransformerClasses() {
        return this.classTransformerClasses;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModpackName() {
        return this.modpackName;
    }

    public String getModpackVersion() {
        return this.modpackVersion;
    }

    public String getCheckUpdateUrl() {
        return this.checkUpdateUrl;
    }

    public String getUpdateURI() {
        return this.updateURI;
    }

    public static LocalModFile fromFile(ModManager modManager, Path modFile, ZipFileTree tree) throws IOException, JsonParseException {
        ZipArchiveEntry entry = (ZipArchiveEntry)tree.getEntry("litemod.json");
        if (entry == null) {
            throw new IOException("File " + String.valueOf(modFile) + " is not a LiteLoader mod.");
        }
        LiteModMetadata metadata = JsonUtils.fromJsonFully(tree.getInputStream(entry), LiteModMetadata.class);
        if (metadata == null) {
            throw new IOException("Mod " + String.valueOf(modFile) + " `litemod.json` is malformed.");
        }
        return new LocalModFile(modManager, modManager.getLocalMod(metadata.getName(), ModLoaderType.LITE_LOADER), modFile, metadata.getName(), new LocalModFile.Description(metadata.getDescription()), metadata.getAuthor(), metadata.getVersion(), metadata.getGameVersion(), metadata.getUpdateURI(), "");
    }
}

