/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta.provider;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CancellationException;
import javafx.beans.value.ObservableDoubleValue;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaBundle;

public abstract class AbstractTerracottaProvider {
    protected final TerracottaBundle bundle;

    protected AbstractTerracottaProvider(TerracottaBundle bundle) {
        this.bundle = bundle;
    }

    public Status status() throws IOException {
        return this.bundle.status();
    }

    public final Task<Path> download(DownloadContext progress) {
        return this.bundle.download(progress);
    }

    public Task<?> install(Path pkg) throws IOException {
        return this.bundle.install(pkg);
    }

    public abstract List<String> ofCommandLine(Path var1);

    public static enum Status {
        NOT_EXIST,
        LEGACY_VERSION,
        READY;

    }

    public static interface DownloadContext {
        public void bindProgress(ObservableDoubleValue var1);

        public void checkCancellation() throws CancellationException;
    }
}

