#include "WelcomeManager.hpp"
#include "../debug/Log.hpp"
#include "../config/ConfigValue.hpp"
#include "../helpers/fs/FsUtils.hpp"

#include <hyprutils/os/Process.hpp>

using namespace Hyprutils::OS;

CWelcomeManager::CWelcomeManager() {
    static auto PAUTOGEN = CConfigValue<Hyprlang::INT>("autogenerated");

    if (!*PAUTOGEN) {
        Debug::log(LOG, "[welcome] skipping, not autogen");
        return;
    }

    if (!NFsUtils::executableExistsInPath("hyprland-welcome")) {
        Debug::log(LOG, "[welcome] skipping, no welcome app");
        return;
    }

    m_fired = true;

    CProcess welcome("hyprland-welcome", {});
    welcome.runAsync();
}

bool CWelcomeManager::fired() {
    return m_fired;
}
