#ifndef openjpeg_mangle_h
#define openjpeg_mangle_h

/*

OpenJPEG has a well defined versioned API and ABI that is consistent across platforms.

The following command was used to obtain the symbol list on macOS:

Mac: nm -g lib/libitkopenjpeg* 2> /dev/null | grep " [TDRS] " | awk '{ print substr($3, 2); }' | awk '{ sub(/itkopenjpeg_/, ""); print }' | sed 's/\(.*\)/#define \1\ itkopenjpeg_\1/' | sort

The following command was used to obtain the symbol list on Linux:

Linux: nm -g lib/libitktiff* 2> /dev/null | grep " [TDRS] " | awk '{ print $3 }' | awk '{ sub(/itkopenjpeg_/, ""); print }' | sed 's/\(.*\)/#define \1\ itkopenjpeg_\1/' | sort
*/

#define j2k_destroy_cstr_index itkopenjpeg_j2k_destroy_cstr_index
#define j2k_dump itkopenjpeg_j2k_dump
#define j2k_dump_image_comp_header itkopenjpeg_j2k_dump_image_comp_header
#define j2k_dump_image_header itkopenjpeg_j2k_dump_image_header
#define j2k_get_cstr_index itkopenjpeg_j2k_get_cstr_index
#define j2k_get_cstr_info itkopenjpeg_j2k_get_cstr_info
#define jp2_dump itkopenjpeg_jp2_dump
#define jp2_get_cstr_index itkopenjpeg_jp2_get_cstr_index
#define jp2_get_cstr_info itkopenjpeg_jp2_get_cstr_info
#define opj_aligned_32_malloc itkopenjpeg_opj_aligned_32_malloc
#define opj_aligned_32_realloc itkopenjpeg_opj_aligned_32_realloc
#define opj_aligned_free itkopenjpeg_opj_aligned_free
#define opj_aligned_malloc itkopenjpeg_opj_aligned_malloc
#define opj_aligned_realloc itkopenjpeg_opj_aligned_realloc
#define opj_alloc_tile_component_data itkopenjpeg_opj_alloc_tile_component_data
#define opj_bio_create itkopenjpeg_opj_bio_create
#define opj_bio_destroy itkopenjpeg_opj_bio_destroy
#define opj_bio_flush itkopenjpeg_opj_bio_flush
#define opj_bio_inalign itkopenjpeg_opj_bio_inalign
#define opj_bio_init_dec itkopenjpeg_opj_bio_init_dec
#define opj_bio_init_enc itkopenjpeg_opj_bio_init_enc
#define opj_bio_numbytes itkopenjpeg_opj_bio_numbytes
#define opj_bio_putbit itkopenjpeg_opj_bio_putbit
#define opj_bio_read itkopenjpeg_opj_bio_read
#define opj_bio_write itkopenjpeg_opj_bio_write
#define opj_calculate_norms itkopenjpeg_opj_calculate_norms
#define opj_calloc itkopenjpeg_opj_calloc
#define opj_clock itkopenjpeg_opj_clock
#define opj_codec_set_threads itkopenjpeg_opj_codec_set_threads
#define opj_cond_create itkopenjpeg_opj_cond_create
#define opj_cond_destroy itkopenjpeg_opj_cond_destroy
#define opj_cond_signal itkopenjpeg_opj_cond_signal
#define opj_cond_wait itkopenjpeg_opj_cond_wait
#define opj_copy_image_header itkopenjpeg_opj_copy_image_header
#define opj_create_compress itkopenjpeg_opj_create_compress
#define opj_create_decompress itkopenjpeg_opj_create_decompress
#define opj_decode itkopenjpeg_opj_decode
#define opj_decode_tile_data itkopenjpeg_opj_decode_tile_data
#define opj_decoder_set_strict_mode itkopenjpeg_opj_decoder_set_strict_mode
#define opj_destroy_codec itkopenjpeg_opj_destroy_codec
#define opj_destroy_cstr_index itkopenjpeg_opj_destroy_cstr_index
#define opj_destroy_cstr_info itkopenjpeg_opj_destroy_cstr_info
#define opj_dump_codec itkopenjpeg_opj_dump_codec
#define opj_dwt_calc_explicit_stepsizes itkopenjpeg_opj_dwt_calc_explicit_stepsizes
#define opj_dwt_decode itkopenjpeg_opj_dwt_decode
#define opj_dwt_decode_real itkopenjpeg_opj_dwt_decode_real
#define opj_dwt_encode itkopenjpeg_opj_dwt_encode
#define opj_dwt_encode_real itkopenjpeg_opj_dwt_encode_real
#define opj_dwt_getnorm itkopenjpeg_opj_dwt_getnorm
#define opj_dwt_getnorm_real itkopenjpeg_opj_dwt_getnorm_real
#define opj_encode itkopenjpeg_opj_encode
#define opj_encoder_set_extra_options itkopenjpeg_opj_encoder_set_extra_options
#define opj_end_compress itkopenjpeg_opj_end_compress
#define opj_end_decompress itkopenjpeg_opj_end_decompress
#define opj_event_msg itkopenjpeg_opj_event_msg
#define opj_free itkopenjpeg_opj_free
#define opj_get_cstr_index itkopenjpeg_opj_get_cstr_index
#define opj_get_cstr_info itkopenjpeg_opj_get_cstr_info
#define opj_get_decoded_tile itkopenjpeg_opj_get_decoded_tile
#define opj_get_encoding_packet_count itkopenjpeg_opj_get_encoding_packet_count
#define opj_get_num_cpus itkopenjpeg_opj_get_num_cpus
#define opj_has_thread_support itkopenjpeg_opj_has_thread_support
#define opj_image_comp_header_update itkopenjpeg_opj_image_comp_header_update
#define opj_image_create itkopenjpeg_opj_image_create
#define opj_image_create0 itkopenjpeg_opj_image_create0
#define opj_image_data_alloc itkopenjpeg_opj_image_data_alloc
#define opj_image_data_free itkopenjpeg_opj_image_data_free
#define opj_image_destroy itkopenjpeg_opj_image_destroy
#define opj_image_tile_create itkopenjpeg_opj_image_tile_create
#define opj_j2k_convert_progression_order itkopenjpeg_opj_j2k_convert_progression_order
#define opj_j2k_create_compress itkopenjpeg_opj_j2k_create_compress
#define opj_j2k_create_decompress itkopenjpeg_opj_j2k_create_decompress
#define opj_j2k_decode itkopenjpeg_opj_j2k_decode
#define opj_j2k_decode_tile itkopenjpeg_opj_j2k_decode_tile
#define opj_j2k_decoder_set_strict_mode itkopenjpeg_opj_j2k_decoder_set_strict_mode
#define opj_j2k_destroy itkopenjpeg_opj_j2k_destroy
#define opj_j2k_encode itkopenjpeg_opj_j2k_encode
#define opj_j2k_encoder_set_extra_options itkopenjpeg_opj_j2k_encoder_set_extra_options
#define opj_j2k_end_compress itkopenjpeg_opj_j2k_end_compress
#define opj_j2k_end_decompress itkopenjpeg_opj_j2k_end_decompress
#define opj_j2k_get_tile itkopenjpeg_opj_j2k_get_tile
#define opj_j2k_read_header itkopenjpeg_opj_j2k_read_header
#define opj_j2k_read_tile_header itkopenjpeg_opj_j2k_read_tile_header
#define opj_j2k_set_decode_area itkopenjpeg_opj_j2k_set_decode_area
#define opj_j2k_set_decoded_components itkopenjpeg_opj_j2k_set_decoded_components
#define opj_j2k_set_decoded_resolution_factor itkopenjpeg_opj_j2k_set_decoded_resolution_factor
#define opj_j2k_set_threads itkopenjpeg_opj_j2k_set_threads
#define opj_j2k_setup_decoder itkopenjpeg_opj_j2k_setup_decoder
#define opj_j2k_setup_encoder itkopenjpeg_opj_j2k_setup_encoder
#define opj_j2k_setup_mct_encoding itkopenjpeg_opj_j2k_setup_mct_encoding
#define opj_j2k_start_compress itkopenjpeg_opj_j2k_start_compress
#define opj_j2k_write_tile itkopenjpeg_opj_j2k_write_tile
#define opj_jp2_create itkopenjpeg_opj_jp2_create
#define opj_jp2_decode itkopenjpeg_opj_jp2_decode
#define opj_jp2_decode_tile itkopenjpeg_opj_jp2_decode_tile
#define opj_jp2_decoder_set_strict_mode itkopenjpeg_opj_jp2_decoder_set_strict_mode
#define opj_jp2_destroy itkopenjpeg_opj_jp2_destroy
#define opj_jp2_encode itkopenjpeg_opj_jp2_encode
#define opj_jp2_encoder_set_extra_options itkopenjpeg_opj_jp2_encoder_set_extra_options
#define opj_jp2_end_compress itkopenjpeg_opj_jp2_end_compress
#define opj_jp2_end_decompress itkopenjpeg_opj_jp2_end_decompress
#define opj_jp2_get_tile itkopenjpeg_opj_jp2_get_tile
#define opj_jp2_read_header itkopenjpeg_opj_jp2_read_header
#define opj_jp2_read_tile_header itkopenjpeg_opj_jp2_read_tile_header
#define opj_jp2_set_decode_area itkopenjpeg_opj_jp2_set_decode_area
#define opj_jp2_set_decoded_components itkopenjpeg_opj_jp2_set_decoded_components
#define opj_jp2_set_decoded_resolution_factor itkopenjpeg_opj_jp2_set_decoded_resolution_factor
#define opj_jp2_set_threads itkopenjpeg_opj_jp2_set_threads
#define opj_jp2_setup_decoder itkopenjpeg_opj_jp2_setup_decoder
#define opj_jp2_setup_encoder itkopenjpeg_opj_jp2_setup_encoder
#define opj_jp2_start_compress itkopenjpeg_opj_jp2_start_compress
#define opj_jp2_write_tile itkopenjpeg_opj_jp2_write_tile
#define opj_malloc itkopenjpeg_opj_malloc
#define opj_matrix_inversion_f itkopenjpeg_opj_matrix_inversion_f
#define opj_mct_decode itkopenjpeg_opj_mct_decode
#define opj_mct_decode_custom itkopenjpeg_opj_mct_decode_custom
#define opj_mct_decode_real itkopenjpeg_opj_mct_decode_real
#define opj_mct_encode itkopenjpeg_opj_mct_encode
#define opj_mct_encode_custom itkopenjpeg_opj_mct_encode_custom
#define opj_mct_encode_real itkopenjpeg_opj_mct_encode_real
#define opj_mct_get_mct_norms itkopenjpeg_opj_mct_get_mct_norms
#define opj_mct_get_mct_norms_real itkopenjpeg_opj_mct_get_mct_norms_real
#define opj_mct_getnorm itkopenjpeg_opj_mct_getnorm
#define opj_mct_getnorm_real itkopenjpeg_opj_mct_getnorm_real
#define opj_mqc_bypass_enc itkopenjpeg_opj_mqc_bypass_enc
#define opj_mqc_bypass_flush_enc itkopenjpeg_opj_mqc_bypass_flush_enc
#define opj_mqc_bypass_get_extra_bytes itkopenjpeg_opj_mqc_bypass_get_extra_bytes
#define opj_mqc_bypass_init_enc itkopenjpeg_opj_mqc_bypass_init_enc
#define opj_mqc_byteout itkopenjpeg_opj_mqc_byteout
#define opj_mqc_erterm_enc itkopenjpeg_opj_mqc_erterm_enc
#define opj_mqc_flush itkopenjpeg_opj_mqc_flush
#define opj_mqc_init_dec itkopenjpeg_opj_mqc_init_dec
#define opj_mqc_init_enc itkopenjpeg_opj_mqc_init_enc
#define opj_mqc_numbytes itkopenjpeg_opj_mqc_numbytes
#define opj_mqc_raw_init_dec itkopenjpeg_opj_mqc_raw_init_dec
#define opj_mqc_reset_enc itkopenjpeg_opj_mqc_reset_enc
#define opj_mqc_resetstates itkopenjpeg_opj_mqc_resetstates
#define opj_mqc_restart_init_enc itkopenjpeg_opj_mqc_restart_init_enc
#define opj_mqc_segmark_enc itkopenjpeg_opj_mqc_segmark_enc
#define opj_mqc_setstate itkopenjpeg_opj_mqc_setstate
#define opj_mutex_create itkopenjpeg_opj_mutex_create
#define opj_mutex_destroy itkopenjpeg_opj_mutex_destroy
#define opj_mutex_lock itkopenjpeg_opj_mutex_lock
#define opj_mutex_unlock itkopenjpeg_opj_mutex_unlock
#define opj_pi_create_decode itkopenjpeg_opj_pi_create_decode
#define opj_pi_create_encode itkopenjpeg_opj_pi_create_encode
#define opj_pi_destroy itkopenjpeg_opj_pi_destroy
#define opj_pi_initialise_encode itkopenjpeg_opj_pi_initialise_encode
#define opj_pi_next itkopenjpeg_opj_pi_next
#define opj_pi_update_encoding_parameters itkopenjpeg_opj_pi_update_encoding_parameters
#define opj_procedure_list_add_procedure itkopenjpeg_opj_procedure_list_add_procedure
#define opj_procedure_list_clear itkopenjpeg_opj_procedure_list_clear
#define opj_procedure_list_create itkopenjpeg_opj_procedure_list_create
#define opj_procedure_list_destroy itkopenjpeg_opj_procedure_list_destroy
#define opj_procedure_list_get_first_procedure itkopenjpeg_opj_procedure_list_get_first_procedure
#define opj_procedure_list_get_nb_procedures itkopenjpeg_opj_procedure_list_get_nb_procedures
#define opj_read_bytes_BE itkopenjpeg_opj_read_bytes_BE
#define opj_read_bytes_LE itkopenjpeg_opj_read_bytes_LE
#define opj_read_double_BE itkopenjpeg_opj_read_double_BE
#define opj_read_double_LE itkopenjpeg_opj_read_double_LE
#define opj_read_float_BE itkopenjpeg_opj_read_float_BE
#define opj_read_float_LE itkopenjpeg_opj_read_float_LE
#define opj_read_header itkopenjpeg_opj_read_header
#define opj_read_tile_header itkopenjpeg_opj_read_tile_header
#define opj_realloc itkopenjpeg_opj_realloc
#define opj_set_MCT itkopenjpeg_opj_set_MCT
#define opj_set_decode_area itkopenjpeg_opj_set_decode_area
#define opj_set_decoded_components itkopenjpeg_opj_set_decoded_components
#define opj_set_decoded_resolution_factor itkopenjpeg_opj_set_decoded_resolution_factor
#define opj_set_default_decoder_parameters itkopenjpeg_opj_set_default_decoder_parameters
#define opj_set_default_encoder_parameters itkopenjpeg_opj_set_default_encoder_parameters
#define opj_set_default_event_handler itkopenjpeg_opj_set_default_event_handler
#define opj_set_error_handler itkopenjpeg_opj_set_error_handler
#define opj_set_info_handler itkopenjpeg_opj_set_info_handler
#define opj_set_warning_handler itkopenjpeg_opj_set_warning_handler
#define opj_setup_decoder itkopenjpeg_opj_setup_decoder
#define opj_setup_encoder itkopenjpeg_opj_setup_encoder
#define opj_sparse_array_int32_create itkopenjpeg_opj_sparse_array_int32_create
#define opj_sparse_array_int32_free itkopenjpeg_opj_sparse_array_int32_free
#define opj_sparse_array_int32_read itkopenjpeg_opj_sparse_array_int32_read
#define opj_sparse_array_int32_write itkopenjpeg_opj_sparse_array_int32_write
#define opj_sparse_array_is_region_valid itkopenjpeg_opj_sparse_array_is_region_valid
#define opj_start_compress itkopenjpeg_opj_start_compress
#define opj_stream_create itkopenjpeg_opj_stream_create
#define opj_stream_create_default_file_stream itkopenjpeg_opj_stream_create_default_file_stream
#define opj_stream_create_file_stream itkopenjpeg_opj_stream_create_file_stream
#define opj_stream_default_create itkopenjpeg_opj_stream_default_create
#define opj_stream_default_read itkopenjpeg_opj_stream_default_read
#define opj_stream_default_seek itkopenjpeg_opj_stream_default_seek
#define opj_stream_default_skip itkopenjpeg_opj_stream_default_skip
#define opj_stream_default_write itkopenjpeg_opj_stream_default_write
#define opj_stream_destroy itkopenjpeg_opj_stream_destroy
#define opj_stream_flush itkopenjpeg_opj_stream_flush
#define opj_stream_get_number_byte_left itkopenjpeg_opj_stream_get_number_byte_left
#define opj_stream_has_seek itkopenjpeg_opj_stream_has_seek
#define opj_stream_read_data itkopenjpeg_opj_stream_read_data
#define opj_stream_read_seek itkopenjpeg_opj_stream_read_seek
#define opj_stream_read_skip itkopenjpeg_opj_stream_read_skip
#define opj_stream_seek itkopenjpeg_opj_stream_seek
#define opj_stream_set_read_function itkopenjpeg_opj_stream_set_read_function
#define opj_stream_set_seek_function itkopenjpeg_opj_stream_set_seek_function
#define opj_stream_set_skip_function itkopenjpeg_opj_stream_set_skip_function
#define opj_stream_set_user_data itkopenjpeg_opj_stream_set_user_data
#define opj_stream_set_user_data_length itkopenjpeg_opj_stream_set_user_data_length
#define opj_stream_set_write_function itkopenjpeg_opj_stream_set_write_function
#define opj_stream_skip itkopenjpeg_opj_stream_skip
#define opj_stream_tell itkopenjpeg_opj_stream_tell
#define opj_stream_write_data itkopenjpeg_opj_stream_write_data
#define opj_stream_write_seek itkopenjpeg_opj_stream_write_seek
#define opj_stream_write_skip itkopenjpeg_opj_stream_write_skip
#define opj_t1_create itkopenjpeg_opj_t1_create
#define opj_t1_decode_cblks itkopenjpeg_opj_t1_decode_cblks
#define opj_t1_destroy itkopenjpeg_opj_t1_destroy
#define opj_t1_encode_cblks itkopenjpeg_opj_t1_encode_cblks
#define opj_t1_ht_decode_cblk itkopenjpeg_opj_t1_ht_decode_cblk
#define opj_t2_create itkopenjpeg_opj_t2_create
#define opj_t2_decode_packets itkopenjpeg_opj_t2_decode_packets
#define opj_t2_destroy itkopenjpeg_opj_t2_destroy
#define opj_t2_encode_packets itkopenjpeg_opj_t2_encode_packets
#define opj_tcd_copy_tile_data itkopenjpeg_opj_tcd_copy_tile_data
#define opj_tcd_create itkopenjpeg_opj_tcd_create
#define opj_tcd_decode_tile itkopenjpeg_opj_tcd_decode_tile
#define opj_tcd_destroy itkopenjpeg_opj_tcd_destroy
#define opj_tcd_encode_tile itkopenjpeg_opj_tcd_encode_tile
#define opj_tcd_get_decoded_tile_size itkopenjpeg_opj_tcd_get_decoded_tile_size
#define opj_tcd_get_encoder_input_buffer_size itkopenjpeg_opj_tcd_get_encoder_input_buffer_size
#define opj_tcd_init itkopenjpeg_opj_tcd_init
#define opj_tcd_init_decode_tile itkopenjpeg_opj_tcd_init_decode_tile
#define opj_tcd_init_encode_tile itkopenjpeg_opj_tcd_init_encode_tile
#define opj_tcd_is_band_empty itkopenjpeg_opj_tcd_is_band_empty
#define opj_tcd_is_subband_area_of_interest itkopenjpeg_opj_tcd_is_subband_area_of_interest
#define opj_tcd_marker_info_create itkopenjpeg_opj_tcd_marker_info_create
#define opj_tcd_marker_info_destroy itkopenjpeg_opj_tcd_marker_info_destroy
#define opj_tcd_reinit_segment itkopenjpeg_opj_tcd_reinit_segment
#define opj_tcd_update_tile_data itkopenjpeg_opj_tcd_update_tile_data
#define opj_tgt_create itkopenjpeg_opj_tgt_create
#define opj_tgt_decode itkopenjpeg_opj_tgt_decode
#define opj_tgt_destroy itkopenjpeg_opj_tgt_destroy
#define opj_tgt_encode itkopenjpeg_opj_tgt_encode
#define opj_tgt_init itkopenjpeg_opj_tgt_init
#define opj_tgt_reset itkopenjpeg_opj_tgt_reset
#define opj_tgt_setvalue itkopenjpeg_opj_tgt_setvalue
#define opj_thread_create itkopenjpeg_opj_thread_create
#define opj_thread_join itkopenjpeg_opj_thread_join
#define opj_thread_pool_create itkopenjpeg_opj_thread_pool_create
#define opj_thread_pool_destroy itkopenjpeg_opj_thread_pool_destroy
#define opj_thread_pool_get_thread_count itkopenjpeg_opj_thread_pool_get_thread_count
#define opj_thread_pool_submit_job itkopenjpeg_opj_thread_pool_submit_job
#define opj_thread_pool_wait_completion itkopenjpeg_opj_thread_pool_wait_completion
#define opj_tls_get itkopenjpeg_opj_tls_get
#define opj_tls_set itkopenjpeg_opj_tls_set
#define opj_version itkopenjpeg_opj_version
#define opj_write_bytes_BE itkopenjpeg_opj_write_bytes_BE
#define opj_write_bytes_LE itkopenjpeg_opj_write_bytes_LE
#define opj_write_double_BE itkopenjpeg_opj_write_double_BE
#define opj_write_double_LE itkopenjpeg_opj_write_double_LE
#define opj_write_float_BE itkopenjpeg_opj_write_float_BE
#define opj_write_float_LE itkopenjpeg_opj_write_float_LE
#define opj_write_tile itkopenjpeg_opj_write_tile
#define opq_mqc_finish_dec itkopenjpeg_opq_mqc_finish_dec

#endif // openjpeg_mangle_h
