// This is core/vnl/vnl_matlab_write.h
#ifndef vnl_matlab_write_h_
#define vnl_matlab_write_h_
//:
//  \file
//  \brief Write to a MAT file
//
// Core code stolen from D. Capel's code. These functions are useful
// because they allow one to write, say, an image buffer to a MAT file.
//
// NB. with these functions, the variable name \e must be a non-null and
// point to a zero-terminated string. otherwise the code will segfault.
//
//  \author fsm
//
// \verbatim
//  Modifications
//   09 Mar 2000 fsm. changed order of arguments for consistency with \sa vnl_matlab_read.
// \endverbatim

#include <iosfwd>
#ifdef _MSC_VER
#  include <vcl_msvc_warnings.h>
#endif
#include "vnl/vnl_export.h"

template <class T>
VNL_EXPORT // scalar
  bool
  vnl_matlab_write(std::ostream &, const T &, const char * variable_name);

template <class T>
VNL_EXPORT // 1D array
  bool
  vnl_matlab_write(std::ostream &, const T *, unsigned size, const char * variable_name);

template <class T>
VNL_EXPORT // 2D array
  bool
  vnl_matlab_write(std::ostream &, const T * const *, unsigned rows, unsigned cols, const char * variable_name);

#endif // vnl_matlab_write_h_
