/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.decompiler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.DecompilerResult;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.decompiler.DecompilerImpl;
import org.eclipse.jdt.ls.core.internal.decompiler.DecompilerType;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class FernFlowerDecompiler
extends DecompilerImpl {
    public static final String DECOMPILER_HEADER = "// Source code is decompiled from a .class file using FernFlower decompiler (from Intellij IDEA).\n";

    public static boolean isDecompiledContents(String contents) {
        return contents != null && contents.startsWith(DECOMPILER_HEADER);
    }

    @Override
    protected DecompilerResult decompileContent(URI uri, IProgressMonitor monitor) throws CoreException {
        return this.getContent(new BytecodeProvider(uri), monitor);
    }

    @Override
    protected DecompilerResult decompileContent(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        return this.getContent(new BytecodeProvider(classFile), monitor);
    }

    @Override
    protected DecompilerType getDecompilerType() {
        return DecompilerType.FERNFLOWER;
    }

    private DecompilerResult getContent(BytecodeProvider provider, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> decompilerOptions = new HashMap<String, String>();
        decompilerOptions.put("hdc", "0");
        decompilerOptions.put("iib", "1");
        decompilerOptions.put("rsy", "1");
        decompilerOptions.put("rbr", "1");
        decompilerOptions.put("dgs", "1");
        decompilerOptions.put("din", "1");
        decompilerOptions.put("den", "1");
        decompilerOptions.put("log", IFernflowerLogger.Severity.ERROR.name());
        decompilerOptions.put("asc", "0");
        decompilerOptions.put("bsm", "1");
        if (Boolean.getBoolean("jdt.ls.debug")) {
            decompilerOptions.put("__dump_original_lines__", "1");
        }
        ResultSaver resultSaver = new ResultSaver();
        BaseDecompiler fernflower = new BaseDecompiler((IBytecodeProvider)provider, (IResultSaver)resultSaver, decompilerOptions, new IFernflowerLogger(){

            public void writeMessage(String message, IFernflowerLogger.Severity severity) {
                if (severity.ordinal() >= IFernflowerLogger.Severity.ERROR.ordinal()) {
                    JavaLanguageServerPlugin.logError(message);
                }
            }

            public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
                if (severity.ordinal() >= IFernflowerLogger.Severity.ERROR.ordinal()) {
                    JavaLanguageServerPlugin.logException(message, t);
                }
            }
        });
        fernflower.addSource(new File("__Fernflower__.class"));
        fernflower.decompileContext();
        String decompiledCode = DECOMPILER_HEADER + resultSaver.content;
        TreeMap<Integer, Set> originalLineMappings = new TreeMap<Integer, Set>();
        TreeMap<Integer, Set> decompiledLineMappings = new TreeMap<Integer, Set>();
        if (resultSaver.originalLinesMapping != null) {
            int i = 0;
            while (i + 1 < resultSaver.originalLinesMapping.length) {
                int srcLine = resultSaver.originalLinesMapping[i];
                int decompiledLine = resultSaver.originalLinesMapping[i + 1] + 1;
                Set decompiled = originalLineMappings.computeIfAbsent(srcLine, k -> new TreeSet());
                decompiled.add(decompiledLine);
                Set src = decompiledLineMappings.computeIfAbsent(decompiledLine, k -> new TreeSet());
                src.add(srcLine);
                i += 2;
            }
        } else {
            JavaLanguageServerPlugin.logInfo("Line mappings not available for decompiled content - decompilation may have failed or line mapping was disabled");
        }
        ArrayList<Integer> originals = new ArrayList<Integer>(originalLineMappings.size() * 2);
        for (Map.Entry entry : originalLineMappings.entrySet()) {
            int original = (Integer)entry.getKey();
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                originals.add(original);
                originals.add(value);
            }
        }
        ArrayList<Integer> decompiles = new ArrayList<Integer>(decompiledLineMappings.size() * 2);
        for (Map.Entry entry : decompiledLineMappings.entrySet()) {
            int decompiled = (Integer)entry.getKey();
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                decompiles.add(decompiled);
                decompiles.add(value);
            }
        }
        return new DecompilerResult(decompiledCode, originals.stream().mapToInt(Integer::intValue).toArray(), decompiles.stream().mapToInt(Integer::intValue).toArray());
    }

    static class BytecodeProvider
    implements IBytecodeProvider {
        private URI uri;
        private byte[] classBytes;

        public BytecodeProvider(URI uri) {
            this.uri = uri;
        }

        public BytecodeProvider(IClassFile classFile) {
            try {
                this.classBytes = this.readClassFileBytes(classFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
            if (this.classBytes != null) {
                return this.classBytes;
            }
            if (this.uri == null) {
                return null;
            }
            this.classBytes = this.readClassFileBytes(JDTUtils.resolveClassFile(this.uri));
            if (this.classBytes == null) {
                this.classBytes = Files.readAllBytes(Paths.get(this.uri));
            }
            return this.classBytes;
        }

        private byte[] readClassFileBytes(IClassFile classFile) throws IOException {
            if (classFile == null) {
                return null;
            }
            try {
                return classFile.getBytes();
            }
            catch (JavaModelException e) {
                throw new IOException(e);
            }
        }
    }

    static class ResultSaver
    implements IResultSaver {
        private String content;
        private int[] originalLinesMapping;

        ResultSaver() {
        }

        public void closeArchive(String arg0, String arg1) {
        }

        public void copyEntry(String arg0, String arg1, String arg2, String arg3) {
        }

        public void copyFile(String arg0, String arg1, String arg2) {
        }

        public void createArchive(String arg0, String arg1, Manifest arg2) {
        }

        public void saveClassEntry(String arg0, String arg1, String arg2, String arg3, String arg4) {
        }

        public void saveClassFile(String filename, String qualifiedName, String entryName, String content, int[] originalLinesMapping) {
            this.content = content;
            this.originalLinesMapping = originalLinesMapping;
        }

        public void saveDirEntry(String arg0, String arg1, String arg2) {
        }

        public void saveFolder(String arg0) {
        }
    }
}

