"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const BaseItem_1 = require("@joplin/lib/models/BaseItem");
const Note_1 = require("@joplin/lib/models/Note");
class Command extends base_command_1.default {
    usage() {
        return 'cat <note>';
    }
    description() {
        return (0, locale_1._)('Displays the given note.');
    }
    options() {
        return [['-v, --verbose', (0, locale_1._)('Displays the complete information about note.')]];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const title = args['note'];
        const item = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_NOTE, title, { parent: (0, app_1.default)().currentFolder() });
        if (!item)
            throw new Error((0, locale_1._)('Cannot find "%s".', title));
        let content = '';
        if (item.encryption_applied) {
            content = BaseItem_1.default.displayTitle(item);
        }
        else {
            content = args.options.verbose ? await Note_1.default.serialize(item) : await Note_1.default.serializeForEdit(item);
        }
        this.stdout(content);
        (0, app_1.default)().gui().showConsole();
        (0, app_1.default)().gui().maximizeConsole();
    }
}
module.exports = Command;
//# sourceMappingURL=command-cat.js.map