"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const Setting_1 = require("@joplin/lib/models/Setting");
const ReportService_1 = require("@joplin/lib/services/ReportService");
const fs = require("fs-extra");
class Command extends base_command_1.default {
    usage() {
        return 'export-sync-status';
    }
    description() {
        return 'Export sync status';
    }
    hidden() {
        return true;
    }
    async action() {
        const service = new ReportService_1.default();
        const csv = await service.basicItemList({ format: 'csv' });
        const filePath = `${Setting_1.default.value('profileDir')}/syncReport-${new Date().getTime()}.csv`;
        await fs.writeFileSync(filePath, csv);
        this.stdout(`Sync status exported to ${filePath}`);
        (0, app_1.default)()
            .gui()
            .showConsole();
        (0, app_1.default)()
            .gui()
            .maximizeConsole();
    }
}
module.exports = Command;
//# sourceMappingURL=command-export-sync-status.js.map