"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Note_1 = require("@joplin/lib/models/Note");
class Command extends base_command_1.default {
    usage() {
        return 'geoloc <note>';
    }
    description() {
        return (0, locale_1._)('Displays a geolocation URL for the note.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const title = args['note'];
        const item = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_NOTE, title, { parent: (0, app_1.default)().currentFolder() });
        if (!item)
            throw new Error((0, locale_1._)('Cannot find "%s".', title));
        const url = Note_1.default.geolocationUrl(item);
        this.stdout(url);
        (0, app_1.default)()
            .gui()
            .showConsole();
    }
}
module.exports = Command;
//# sourceMappingURL=command-geoloc.js.map