"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("@joplin/lib/models/Setting");
const types_1 = require("@joplin/lib/services/plugins/api/types");
const shim_1 = require("@joplin/lib/shim");
const BaseCommand = require('./base-command').default;
function settingTypeToSchemaType(type) {
    const map = {
        [types_1.SettingItemType.Int]: 'integer',
        [types_1.SettingItemType.String]: 'string',
        [types_1.SettingItemType.Bool]: 'boolean',
        [types_1.SettingItemType.Array]: 'array',
        [types_1.SettingItemType.Object]: 'object',
        [types_1.SettingItemType.Button]: '',
    };
    const r = map[type];
    if (r === '')
        return '';
    if (!r)
        throw new Error(`Unsupported type: ${type}`);
    return r;
}
class Command extends BaseCommand {
    usage() {
        return 'settingschema <file>';
    }
    description() {
        return 'Build the setting schema file';
    }
    enabled() {
        return false;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        const schema = {
            title: 'JSON schema for Joplin setting files',
            '$id': Setting_1.default.schemaUrl,
            '$schema': 'https://json-schema.org/draft-07/schema#',
            type: 'object',
            properties: {},
        };
        const metadata = Setting_1.default.metadata();
        for (const key of Object.keys(metadata)) {
            const md = metadata[key];
            const type = settingTypeToSchemaType(md.type);
            if (!type)
                continue;
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            const props = {};
            props.type = type;
            props.default = md.value;
            const description = [];
            if (md.label && md.label())
                description.push(md.label());
            if (md.description && md.description(Setting_1.AppType.Desktop))
                description.push(md.description(Setting_1.AppType.Desktop));
            if (description.length)
                props.description = description.join('. ');
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            if (md.isEnum)
                props.enum = Object.keys(md.options()).map((v) => Setting_1.default.formatValue(key, v));
            if ('minimum' in md)
                props.minimum = md.minimum;
            if ('maximum' in md)
                props.maximum = md.maximum;
            if (!md.public || md.storage !== Setting_1.SettingStorage.File)
                props['$comment'] = 'private';
            schema.properties[key] = props;
        }
        const outFilePath = args['file'];
        await shim_1.default.fsDriver().writeFile(outFilePath, JSON.stringify(schema, null, '\t'), 'utf8');
    }
}
module.exports = Command;
//# sourceMappingURL=command-settingschema.js.map