import { Provider } from "@aws-sdk/types";
import { GetterFromEnv } from "./fromEnv";
import { GetterFromConfig, SharedConfigInit } from "./fromSharedConfigFiles";
import { FromStaticConfig } from "./fromStatic";
export type LocalConfigOptions = SharedConfigInit;
export interface LoadedConfigSelectors<T> {
  environmentVariableSelector: GetterFromEnv<T>;
  configFileSelector: GetterFromConfig<T>;
  default: FromStaticConfig<T>;
}
export declare const loadConfig: <T = string>(
  {
    environmentVariableSelector,
    configFileSelector,
    default: defaultValue,
  }: LoadedConfigSelectors<T>,
  configuration?: LocalConfigOptions
) => Provider<T>;
