"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectCustomStyles = exports.loadCustomCss = void 0;
const fs = require("fs-extra");
const loadCustomCss = async (filePath) => {
    let cssString = '';
    if (await fs.pathExists(filePath)) {
        try {
            cssString = await fs.readFile(filePath, 'utf-8');
        }
        catch (error) {
            let msg = error.message ? error.message : '';
            msg = `Could not load custom css from ${filePath}\n${msg}`;
            error.message = msg;
            throw error;
        }
    }
    return cssString;
};
exports.loadCustomCss = loadCustomCss;
const injectCustomStyles = async (elementId, cssFilePath) => {
    const css = await (0, exports.loadCustomCss)(cssFilePath);
    const styleTag = document.createElement('style');
    styleTag.setAttribute('id', elementId);
    styleTag.setAttribute('type', 'text/css');
    styleTag.appendChild(document.createTextNode(css));
    document.head.appendChild(styleTag);
};
exports.injectCustomStyles = injectCustomStyles;
//# sourceMappingURL=CssUtils.js.map