"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("./models/Setting");
const Synchronizer_1 = require("./Synchronizer");
const locale_js_1 = require("./locale.js");
const BaseSyncTarget_1 = require("./BaseSyncTarget");
const SyncTargetJoplinServer_1 = require("./SyncTargetJoplinServer");
class SyncTargetJoplinCloud extends BaseSyncTarget_1.default {
    static id() {
        return 10;
    }
    static supportsConfigCheck() {
        return SyncTargetJoplinServer_1.default.supportsConfigCheck();
    }
    static targetName() {
        return 'joplinCloud';
    }
    static label() {
        return (0, locale_js_1._)('Joplin Cloud');
    }
    static description() {
        return (0, locale_js_1._)('Joplin\'s own sync service. Also gives access to Joplin-specific features such as publishing notes or collaborating on notebooks with others.');
    }
    static supportsSelfHosted() {
        return false;
    }
    static supportsRecursiveLinkedNotes() {
        // Not currently working:
        // https://github.com/laurent22/joplin/pull/6661
        // https://github.com/laurent22/joplin/pull/6600
        return false;
    }
    static supportsShare() {
        return true;
    }
    async isAuthenticated() {
        try {
            const fileApi = await this.fileApi();
            const api = fileApi.driver().api();
            const sessionId = await api.sessionId();
            return !!sessionId;
        }
        catch (error) {
            if (error.code === 403) {
                return false;
            }
            throw error;
        }
    }
    authRouteName() {
        return 'JoplinCloudLogin';
    }
    // While Joplin Cloud requires password, the new login method makes this
    // information useless
    static requiresPassword() {
        return false;
    }
    async fileApi() {
        return super.fileApi();
    }
    static async checkConfig(options) {
        return SyncTargetJoplinServer_1.default.checkConfig(Object.assign({}, options), SyncTargetJoplinCloud.id());
    }
    async initFileApi() {
        return (0, SyncTargetJoplinServer_1.initFileApi)(SyncTargetJoplinCloud.id(), this.logger(), {
            path: () => Setting_1.default.value('sync.10.path'),
            userContentPath: () => Setting_1.default.value('sync.10.userContentPath'),
            username: () => Setting_1.default.value('sync.10.username'),
            password: () => Setting_1.default.value('sync.10.password'),
        });
    }
    async initSynchronizer() {
        return new Synchronizer_1.default(this.db(), await this.fileApi(), Setting_1.default.value('appType'));
    }
}
exports.default = SyncTargetJoplinCloud;
//# sourceMappingURL=SyncTargetJoplinCloud.js.map