"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const welcomeAssetsAny = require('./welcomeAssets');
const Note_1 = require("./models/Note");
const Setting_1 = require("./models/Setting");
const Folder_1 = require("./models/Folder");
const shim_1 = require("./shim");
const uuid_1 = require("./uuid");
const path_utils_1 = require("./path-utils");
const locale_1 = require("./locale");
const { pregQuote } = require('./string-utils');
class WelcomeUtils {
    static async createWelcomeItems(locale) {
        const output = {
            defaultFolderId: null,
        };
        const allWelcomeAssets = welcomeAssetsAny;
        const welcomeAssets = locale in allWelcomeAssets ? allWelcomeAssets[locale] : allWelcomeAssets['en_GB'];
        const enGbWelcomeAssets = allWelcomeAssets['en_GB'];
        const folderAssets = welcomeAssets.folders;
        const tempDir = Setting_1.default.value('resourceDir');
        // Actually we don't really support multiple folders at this point, because not needed
        for (let i = 0; i < folderAssets.length; i++) {
            const folder = await Folder_1.default.save({ title: (0, locale_1._)('Welcome!') });
            if (!output.defaultFolderId)
                output.defaultFolderId = folder.id;
        }
        const noteAssets = welcomeAssets.notes;
        for (let i = noteAssets.length - 1; i >= 0; i--) {
            const noteAsset = noteAssets[i];
            const enGbNoteAsset = enGbWelcomeAssets.notes[i];
            let noteBody = noteAsset.body;
            for (const resourceUrl in enGbNoteAsset.resources) {
                if (!enGbNoteAsset.resources.hasOwnProperty(resourceUrl))
                    continue;
                const resourceAsset = enGbNoteAsset.resources[resourceUrl];
                const ext = (0, path_utils_1.fileExtension)(resourceUrl);
                const tempFilePath = `${tempDir}/${uuid_1.default.create()}.tmp.${ext}`;
                await shim_1.default.fsDriver().writeFile(tempFilePath, resourceAsset.body, 'base64');
                const resource = await shim_1.default.createResourceFromPath(tempFilePath, {
                    title: (0, path_utils_1.basename)(resourceUrl),
                });
                await shim_1.default.fsDriver().remove(tempFilePath);
                const regex = new RegExp(pregQuote(`(${resourceUrl})`), 'g');
                noteBody = noteBody.replace(regex, `(:/${resource.id})`);
            }
            await Note_1.default.save({
                parent_id: output.defaultFolderId,
                title: noteAsset.title,
                body: noteBody,
            });
            // if (noteAsset.tags) await Tag.setNoteTagsByTitles(note.id, noteAsset.tags);
        }
        return output;
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    static async install(locale, dispatch) {
        if (!Setting_1.default.value('welcome.enabled')) {
            Setting_1.default.setValue('welcome.wasBuilt', true);
            return;
        }
        if (!Setting_1.default.value('welcome.wasBuilt')) {
            const result = await WelcomeUtils.createWelcomeItems(locale);
            Setting_1.default.setValue('welcome.wasBuilt', true);
            dispatch({
                type: 'FOLDER_SELECT',
                id: result.defaultFolderId,
            });
            Setting_1.default.setValue('activeFolderId', result.defaultFolderId);
        }
    }
}
exports.default = WelcomeUtils;
//# sourceMappingURL=WelcomeUtils.js.map