"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const file_api_1 = require("./file-api");
const defaultPaginatedList = () => {
    return {
        items: [],
        hasMore: false,
        context: null,
    };
};
const defaultItem = () => {
    return {
        id: '',
    };
};
describe('file-api', () => {
    test.each([
        [
            Object.assign(Object.assign({}, defaultPaginatedList()), { items: [] }),
            false,
        ],
        [
            Object.assign(Object.assign({}, defaultPaginatedList()), { items: [
                    Object.assign(Object.assign({}, defaultItem()), { path: 'test' }),
                ] }),
            false,
        ],
        [
            Object.assign(Object.assign({}, defaultPaginatedList()), { items: [
                    Object.assign(Object.assign({}, defaultItem()), { path: 'test', jopItem: null }),
                ] }),
            true,
        ],
        [
            Object.assign(Object.assign({}, defaultPaginatedList()), { items: [
                    Object.assign(Object.assign({}, defaultItem()), { path: 'test', jopItem: { something: 'abcd' } }),
                ] }),
            true,
        ],
    ])('should tell if the sync target supports delta with items', async (deltaResponse, expected) => {
        const actual = (0, file_api_1.getSupportsDeltaWithItems)(deltaResponse);
        expect(actual).toBe(expected);
    });
});
//# sourceMappingURL=file-api.test.js.map