"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderErrorBlock = void 0;
const versionInfo_1 = require("./versionInfo");
const renderErrorBlock = (errors) => {
    if (!errors.length)
        return '';
    return `\`\`\`\n${errors.map(e => {
        if (typeof e === 'string')
            return e.trim();
        return e.message.trim() + e.stack ? `\n${e.stack}` : '';
    }).map(l => l.trim()).join('\n\n')}\n\`\`\``;
};
exports.renderErrorBlock = renderErrorBlock;
const getOsName = (platform) => {
    if (platform === 'win32')
        return 'Windows';
    if (platform === 'darwin')
        return 'macOS';
    if (platform === 'linux')
        return 'Linux';
    if (platform === 'android')
        return 'Android';
    return '';
};
exports.default = (title, body, errors, packageInfo, pluginService, pluginSettings) => {
    const v = (0, versionInfo_1.default)(packageInfo, pluginService.enabledPlugins(pluginSettings));
    const errorBlock = (0, exports.renderErrorBlock)(errors);
    const query = {
        title,
        category: 'support',
        version: packageInfo.version,
        os: getOsName(process.platform),
        'desktop-about-content': v.body,
        content: `#### Body\n\n${body}${errorBlock ? `\n\n#### Errors\n\n${errorBlock}` : ''}`,
    };
    const queryString = Object.keys(query).map(k => `${k}=${encodeURIComponent(query[k])}`).join('&');
    const url = `https://discourse.joplinapp.org/new-topic?${queryString}`;
    return url;
};
//# sourceMappingURL=makeDiscourseDebugUrl.js.map