"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("../testing/test-utils");
const SearchEngine_1 = require("../services/search/SearchEngine");
const ResourceService_1 = require("../services/ResourceService");
const ItemChangeUtils_1 = require("../services/ItemChangeUtils");
const Note_1 = require("../models/Note");
const ItemChange_1 = require("../models/ItemChange");
let searchEngine = null;
describe('models/ItemChange', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
        searchEngine = new SearchEngine_1.default();
        searchEngine.setDb((0, test_utils_1.db)());
    });
    it('should delete old changes that have been processed', (async () => {
        await Note_1.default.save({ title: 'abcd efgh' });
        await ItemChange_1.default.waitForAllSaved();
        expect(await ItemChange_1.default.lastChangeId()).toBe(1);
        const resourceService = new ResourceService_1.default();
        await searchEngine.syncTables();
        // If we run this now, it should not delete any change because
        // the resource service has not yet processed the change
        await ItemChangeUtils_1.default.deleteProcessedChanges(0);
        expect(await ItemChange_1.default.lastChangeId()).toBe(1);
        await resourceService.indexNoteResources();
        await ItemChangeUtils_1.default.deleteProcessedChanges(0);
        expect(await ItemChange_1.default.lastChangeId()).toBe(1);
        await (0, test_utils_1.revisionService)().collectRevisions();
        // If we don't set a TTL it will default to 90 days so it won't delete
        // either.
        await ItemChangeUtils_1.default.deleteProcessedChanges();
        expect(await ItemChange_1.default.lastChangeId()).toBe(1);
        // All changes should be at least 4 ms old now
        await (0, test_utils_1.msleep)(4);
        // Now it should delete all changes older than 3 ms
        await ItemChangeUtils_1.default.deleteProcessedChanges(3);
        expect(await ItemChange_1.default.lastChangeId()).toBe(0);
    }));
});
//# sourceMappingURL=ItemChange.test.js.map