"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const KeymapService_1 = require("../KeymapService");
const reducer_1 = require("../plugins/reducer");
const propsHaveChanged_1 = require("./propsHaveChanged");
const { createSelectorCreator, defaultMemoize } = require('reselect');
const { createCachedSelector } = require('re-reselect');
const createShallowObjectEqualSelector = createSelectorCreator(defaultMemoize, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
(prev, next) => {
    if (Object.keys(prev).length !== Object.keys(next).length)
        return false;
    for (const n in prev) {
        if (prev[n] !== next[n])
            return false;
    }
    return true;
});
// This selector ensures that for the given command names, the same toolbar
// button array is returned if the underlying toolbar buttons have not changed.
const selectObjectByCommands = createCachedSelector(
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
(state) => state.array, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
(array) => array)({
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    keySelector: (_state, commandNames) => {
        return commandNames.join('_');
    },
    selectorCreator: createShallowObjectEqualSelector,
});
class MenuUtils {
    constructor(service) {
        this.menuItemCache_ = {};
        this.menuItemPropsCache_ = {};
        this.service_ = service;
    }
    get service() {
        return this.service_;
    }
    get keymapService() {
        return KeymapService_1.default.instance();
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    commandToMenuItem(commandName, onClick) {
        const command = this.service.commandByName(commandName);
        const item = {
            id: command.declaration.name,
            label: this.service.label(commandName),
            click: () => onClick(command.declaration.name),
            enabled: true,
        };
        if (command.declaration.role)
            item.role = command.declaration.role;
        if (this.keymapService && this.keymapService.acceleratorExists(commandName)) {
            item.accelerator = this.keymapService.getAccelerator(commandName);
        }
        return item;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    commandToStatefulMenuItem(commandName, ...args) {
        const whenClauseContext = this.service.currentWhenClauseContext();
        const menuItem = this.commandToMenuItem(commandName, () => {
            return this.service.execute(commandName, ...args);
        });
        menuItem.enabled = this.service.isEnabled(commandName, whenClauseContext);
        return menuItem;
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    commandsToMenuItems(commandNames, onClick, locale) {
        const key = `${this.keymapService.lastSaveTime}_${commandNames.join('_')}_${locale}`;
        if (this.menuItemCache_[key])
            return this.menuItemCache_[key];
        const output = {};
        for (const commandName of commandNames) {
            output[commandName] = this.commandToMenuItem(commandName, onClick);
        }
        this.menuItemCache_ = {
            [key]: output,
        };
        return output;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    commandsToMenuItemProps(commandNames, whenClauseContext) {
        const output = {};
        for (const commandName of commandNames) {
            const newProps = {
                enabled: this.service.isEnabled(commandName, whenClauseContext),
            };
            if (newProps === null || (0, propsHaveChanged_1.default)(this.menuItemPropsCache_[commandName], newProps)) {
                output[commandName] = newProps;
                this.menuItemPropsCache_[commandName] = newProps;
            }
            else {
                output[commandName] = this.menuItemPropsCache_[commandName];
            }
        }
        return selectObjectByCommands({ array: output }, commandNames);
    }
    pluginContextMenuItems(plugins, location) {
        const output = [];
        const pluginViewInfos = reducer_1.utils.viewInfosByType(plugins, 'menuItem');
        const whenClauseContext = this.service.currentWhenClauseContext();
        for (const info of pluginViewInfos) {
            if (info.view.location !== location)
                continue;
            const menuItem = this.commandToStatefulMenuItem(info.view.commandName);
            menuItem.enabled = this.service.isEnabled(info.view.commandName, whenClauseContext);
            output.push(menuItem);
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        if (output.length)
            output.splice(0, 0, { type: 'separator' });
        return output;
    }
}
exports.default = MenuUtils;
//# sourceMappingURL=MenuUtils.js.map