"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Logger_1 = require("@joplin/utils/Logger");
const renderViewProps_1 = require("./renderViewProps");
describe('renderViewProps', () => {
    it('should render view props', async () => {
        const view = {
            note: {
                title: 'M&M\'s®',
                user_updated_time: (new Date(2024, 2, 20, 15, 30, 45, 500)).getTime(),
                todo_completed: (new Date(2024, 2, 21, 15, 30, 45, 500)).getTime(),
                isWatched: true,
                is_todo: 1,
                tags: [
                    { title: 'one' },
                    { title: 'two' },
                ],
            },
        };
        await (0, renderViewProps_1.default)(view, [], {
            noteTitleHtml: 'M&amp;M&apos;s&reg;',
        });
        expect(view).toEqual({
            note: {
                title: 'M&amp;M&apos;s&reg;',
                user_updated_time: '20/03/2024 15:30',
                todo_completed: '21/03/2024 15:30',
                isWatched: true,
                is_todo: 1,
                tags: 'one, two',
            },
        });
    });
    it('should handle invalid view props', async () => {
        const view = {
            note: {
                user_updated_time: 'not a number',
                tags: 123,
            },
        };
        Logger_1.default.globalLogger.enabled = false;
        await (0, renderViewProps_1.default)(view, [], {
            noteTitleHtml: '',
        });
        Logger_1.default.globalLogger.enabled = true;
        expect(view).toEqual({
            note: {
                user_updated_time: 'Invalid date',
                tags: 123,
            },
        });
    });
});
//# sourceMappingURL=renderViewProps.test.js.map