"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const filterOcrText_1 = require("./filterOcrText");
const testData = [
    ['— !',
        '',
    ],
    [
        `- = = — ‘ =
—`,
        '',
    ],
    ['', ''],
    ['   testing   ', 'testing'],
];
describe('filterOcrText', () => {
    it('should filter text', () => {
        for (const [input, expected] of testData) {
            expect((0, filterOcrText_1.default)(input)).toBe(expected);
        }
    });
});
//# sourceMappingURL=filterOcrText.test.js.map