"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const validatePluginPlatforms_1 = require("./validatePluginPlatforms");
describe('validatePluginPlatforms', () => {
    test.each([
        [['mobile', 'desktop'], true],
        ['not-an-array', false],
        [[3, 4, 5], false],
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    ])('should throw when given an invalid list of supported plugin platforms (case %#)', (platforms, shouldSupport) => {
        const callback = () => (0, validatePluginPlatforms_1.default)(platforms);
        if (shouldSupport) {
            expect(callback).not.toThrow();
        }
        else {
            expect(callback).toThrow();
        }
    });
});
//# sourceMappingURL=validatePluginPlatforms.test.js.map