"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_synchronizer_1 = require("../../testing/test-utils-synchronizer");
const test_utils_1 = require("../../testing/test-utils");
const Folder_1 = require("../../models/Folder");
const Note_1 = require("../../models/Note");
const tools_1 = require("../../services/synchronizer/tools");
describe('Synchronizer.tools', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(2);
        await (0, test_utils_1.switchClient)(1);
    });
    afterAll(async () => {
        await (0, test_utils_1.afterAllCleanUp)();
    });
    it('should clear local sync data, and re-upload everything to sync target', (async () => {
        await Folder_1.default.save({ title: 'test' });
        await (0, test_utils_1.synchronizerStart)();
        await (0, test_utils_1.fileApi)().clearRoot();
        await (0, tools_1.clearLocalSyncStateForReupload)((0, test_utils_1.db)());
        // Now that the local sync state has been cleared, it should re-upload
        // the items as if it was a new sync target. It should also not delete*
        // any local data.
        await (0, test_utils_1.synchronizerStart)();
        expect((await (0, test_utils_synchronizer_1.remoteNotesAndFolders)()).length).toBe(1);
        expect((await Folder_1.default.all()).length).toBe(1);
    }));
    it('should clear local data, and re-download everything from sync target', (async () => {
        const folder = await Folder_1.default.save({ title: 'test' });
        await Note_1.default.save({ title: 'test note', parent_id: folder.id });
        await (0, test_utils_1.synchronizerStart)();
        await (0, tools_1.clearLocalDataForRedownload)((0, test_utils_1.db)());
        expect((await (0, test_utils_synchronizer_1.allNotesFolders)()).length).toBe(0);
        await (0, test_utils_1.synchronizerStart)();
        expect((await (0, test_utils_synchronizer_1.allNotesFolders)()).length).toBe(2);
        expect((await (0, test_utils_synchronizer_1.remoteNotesAndFolders)()).length).toBe(2);
    }));
});
//# sourceMappingURL=Synchronizer.tools.test.js.map