"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clearLocalSyncStateForReupload = clearLocalSyncStateForReupload;
exports.clearLocalDataForRedownload = clearLocalDataForRedownload;
const BaseItem_1 = require("../../models/BaseItem");
const Setting_1 = require("../../models/Setting");
const SyncTargetRegistry_1 = require("../../SyncTargetRegistry");
async function clearSyncContext() {
    const syncTargetIds = SyncTargetRegistry_1.default.allIds();
    for (const syncTargetId of syncTargetIds) {
        const key = `sync.${syncTargetId}.context`;
        if (Setting_1.default.keyExists(key)) {
            Setting_1.default.resetKey(key);
        }
    }
    await Setting_1.default.saveAll();
}
async function clearLocalSyncStateForReupload(db) {
    const queries = [
        { sql: 'DELETE FROM deleted_items' },
        { sql: 'DELETE FROM sync_items' },
    ];
    await db.transactionExecBatch(queries);
    await clearSyncContext();
}
async function clearLocalDataForRedownload(db) {
    const queries = [
        { sql: 'DELETE FROM deleted_items' },
        { sql: 'DELETE FROM sync_items' },
        { sql: 'DELETE FROM item_changes' },
        { sql: 'DELETE FROM note_resources' },
    ];
    const syncItemTypes = BaseItem_1.default.syncItemTypes();
    for (const syncItemType of syncItemTypes) {
        const SyncItemClass = BaseItem_1.default.getClassByItemType(syncItemType);
        queries.push({ sql: `DELETE FROM ${db.escapeField(SyncItemClass.tableName())}` });
    }
    await db.transactionExecBatch(queries);
    await clearSyncContext();
}
//# sourceMappingURL=tools.js.map