"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clearResourceCache = clearResourceCache;
exports.default = attachedResources;
const BaseModel_1 = require("../BaseModel");
const Note_1 = require("../models/Note");
const Resource_1 = require("../models/Resource");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
let resourceCache_ = {};
function clearResourceCache() {
    resourceCache_ = {};
}
async function attachedResources(noteBody) {
    if (!noteBody)
        return {};
    const resourceIds = await Note_1.default.linkedItemIdsByType(BaseModel_1.default.TYPE_RESOURCE, noteBody);
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    const output = {};
    for (let i = 0; i < resourceIds.length; i++) {
        const id = resourceIds[i];
        if (resourceCache_[id]) {
            output[id] = resourceCache_[id];
        }
        else {
            const resource = await Resource_1.default.load(id);
            const localState = await Resource_1.default.localState(resource);
            const o = {
                item: resource,
                localState: localState,
            };
            // eslint-disable-next-line require-atomic-updates
            resourceCache_[id] = o;
            output[id] = o;
        }
    }
    return output;
}
//# sourceMappingURL=attachedResources.js.map