"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const RemoteMessenger_1 = require("./RemoteMessenger");
class TestMessenger extends RemoteMessenger_1.default {
    constructor(channelId, localApi) {
        super(channelId, localApi);
        this.remoteMessenger = null;
    }
    connectTo(other) {
        if (this.remoteMessenger === other) {
            return;
        }
        if (this.remoteMessenger !== null) {
            throw new Error('TestMessengers can only be connected to a single other messenger');
        }
        this.remoteMessenger = other;
        this.remoteMessenger.connectTo(this);
        this.onReadyToReceive();
    }
    postMessage(message) {
        if (!this.remoteMessenger) {
            throw new Error('No remote messenger has been registered for this TestMessenger. (Was .connectTo called?)');
        }
        void this.remoteMessenger.onMessage(message);
    }
    onClose() {
        this.remoteMessenger = null;
    }
    // Test utility methods
    //
    mockCallbackDropped(callbackId) {
        this.dropRemoteCallback_(callbackId);
    }
}
exports.default = TestMessenger;
//# sourceMappingURL=TestMessenger.js.map