"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkProviderIsSupported = void 0;
const locale_1 = require("../locale");
const Setting_1 = require("../models/Setting");
const url_1 = require("url");
const pathContainsUnsupportedProvider = (path, unsupportedProviders) => {
    try {
        const url = new url_1.URL(path.toLowerCase());
        const splitted = url.host.split('.');
        for (const s of splitted) {
            if (unsupportedProviders.includes(s))
                return true;
        }
        return false;
    }
    catch (error) {
        // The URL is probably invalid, but it's not here that we should handle
        // this.
        return false;
    }
};
const checkProviderIsSupported = (path) => {
    if (Setting_1.default.value('sync.allowUnsupportedProviders') === 1)
        return;
    const unsupportedProviders = ['jianguoyun'];
    for (const p of unsupportedProviders) {
        if (pathContainsUnsupportedProvider(path, unsupportedProviders)) {
            throw new Error((0, locale_1._)('The WebDAV implementation of %s is incompatible with Joplin, and as such is no longer supported. Please use a different sync method.', p));
        }
    }
};
exports.checkProviderIsSupported = checkProviderIsSupported;
exports.default = exports.checkProviderIsSupported;
//# sourceMappingURL=webDAVUtils.js.map