"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("@joplin/lib/locale");
// eslint-disable-next-line @typescript-eslint/ban-types, @typescript-eslint/no-explicit-any -- Old code before rule was applied, Old code before rule was applied
exports.default = (cmd, stdout, store, gui) => {
    cmd.setStdout((text) => {
        return stdout(text);
    });
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    cmd.setDispatcher((action) => {
        if (store()) {
            return store().dispatch(action);
        }
        else {
            return () => { };
        }
    });
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    cmd.setPrompt(async (message, options) => {
        if (!options)
            options = {};
        if (!options.type)
            options.type = 'boolean';
        if (!options.booleanAnswerDefault)
            options.booleanAnswerDefault = 'y';
        if (!options.answers)
            options.answers = options.booleanAnswerDefault === 'y' ? [(0, locale_1._)('Y'), (0, locale_1._)('n')] : [(0, locale_1._)('N'), (0, locale_1._)('y')];
        if (options.type === 'boolean') {
            message += ` (${options.answers.join('/')})`;
        }
        let answer = await gui().prompt('', `${message} `, options);
        if (options.type === 'boolean') {
            if (answer === null)
                return false; // Pressed ESCAPE
            if (!answer)
                answer = options.answers[0];
            const positiveIndex = options.booleanAnswerDefault === 'y' ? 0 : 1;
            return answer.toLowerCase() === options.answers[positiveIndex].toLowerCase();
        }
        else {
            return answer;
        }
    });
    return cmd;
};
//# sourceMappingURL=setupCommand.js.map