"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("@joplin/lib/locale");
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const Logger_1 = require("@joplin/utils/Logger");
const ShareService_1 = require("@joplin/lib/services/share/ShareService");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Note_1 = require("@joplin/lib/models/Note");
const SyncTargetRegistry_1 = require("@joplin/lib/SyncTargetRegistry");
const Setting_1 = require("@joplin/lib/models/Setting");
const registry_1 = require("@joplin/lib/registry");
const logger = Logger_1.default.create('command-unpublish');
class Command extends base_command_1.default {
    usage() {
        return 'publish [note]';
    }
    description() {
        return (0, locale_1._)('Publishes a note to Joplin Server or Joplin Cloud');
    }
    options() {
        return [
            ['-f, --force', (0, locale_1._)('Do not ask for user confirmation.')],
        ];
    }
    enabled() {
        return SyncTargetRegistry_1.default.isJoplinServerOrCloud(Setting_1.default.value('sync.target'));
    }
    async action(args) {
        const targetNote = await (0, app_1.default)().loadItemOrFail(BaseModel_1.ModelType.Note, args.note);
        if (!targetNote.is_shared) {
            throw new Error((0, locale_1._)('Note not published: %s', targetNote.title));
        }
        logger.info('Unshare note: ', targetNote.id);
        await ShareService_1.default.instance().unshareNote(targetNote.id);
        const note = await Note_1.default.load(targetNote.id);
        if (note.is_shared) {
            throw new Error('Assertion failure: The note is still shared.');
        }
        this.stdout((0, locale_1._)('Synchronising...'));
        await registry_1.reg.waitForSyncFinishedThenSync();
    }
}
module.exports = Command;
//# sourceMappingURL=command-unpublish.js.map