"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("../models/Setting");
const time_1 = require("../time");
describe('dateFormats', () => {
    it('should format date according to DATE_FORMAT', (async () => {
        const now = new Date('2017-01-30T12:00:00').getTime();
        // DATE_FORMAT_1 = 'DD/MM/YYYY';
        // DATE_FORMAT_2 = 'DD/MM/YY';
        // DATE_FORMAT_3 = 'MM/DD/YYYY';
        // DATE_FORMAT_4 = 'MM/DD/YY';
        // DATE_FORMAT_5 = 'YYYY-MM-DD';
        // DATE_FORMAT_6 = 'DD.MM.YYYY';
        // DATE_FORMAT_7 = 'YYYY.MM.DD';
        // DATE_FORMAT_8 = 'YYMMDD';
        // DATE_FORMAT_9 = 'YYYY/MM/DD';
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_1)).toBe('30/01/2017');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_2)).toBe('30/01/17');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_3)).toBe('01/30/2017');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_4)).toBe('01/30/17');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_5)).toBe('2017-01-30');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_6)).toBe('30.01.2017');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_7)).toBe('2017.01.30');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_8)).toBe('170130');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.DATE_FORMAT_9)).toBe('2017/01/30');
    }));
    it('should format time according to TIME_FORMAT', (async () => {
        const now = new Date('2017-01-30T20:30:00').getTime();
        // TIME_FORMAT_1 = 'HH:mm';
        // TIME_FORMAT_2 = 'h:mm A';
        // TIME_FORMAT_3 = 'HH.mm';
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.TIME_FORMAT_1)).toBe('20:30');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.TIME_FORMAT_2)).toBe('8:30 PM');
        expect(time_1.default.formatMsToLocal(now, Setting_1.default.TIME_FORMAT_3)).toBe('20.30');
    }));
});
//# sourceMappingURL=dateTimeFormats.test.js.map