"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("../../locale");
const shim_1 = require("../../shim");
const BaseItem_1 = require("../BaseItem");
const Resource_1 = require("../Resource");
const Setting_1 = require("../Setting");
const validations = {
    'sync.target': async (oldValue, newValue) => {
        if (oldValue === 0 || newValue === 0)
            return '';
        const preventChangeMessage = async () => {
            const needToBeFetched = await Resource_1.default.needToBeFetched('always', 1);
            if (needToBeFetched.length)
                return (0, locale_1._)('Some attachments need to be downloaded. Set the attachment download mode to "always" and try again.');
            const downloadErrorCount = await Resource_1.default.downloadStatusCounts(Resource_1.default.FETCH_STATUS_ERROR);
            if (downloadErrorCount > 0)
                return (0, locale_1._)('Some attachments could not be downloaded. Please try to download them again.');
            const disabledCount = await BaseItem_1.default.syncDisabledItemsCount(Setting_1.default.value('sync.target'));
            if (disabledCount > 0)
                return (0, locale_1._)('Some items could not be synchronised. Please try to synchronise them first.');
            return '';
        };
        const message = await preventChangeMessage();
        if (message) {
            const resolutionMessage = shim_1.default.isReactNative() ?
                (0, locale_1._)('Uninstall and reinstall the application. Make sure you create a backup first by exporting all your notes as JEX from the desktop application.') :
                (0, locale_1._)('Close the application, then delete your profile in "%s", and start the application again. Make sure you create a backup first by exporting all your notes as JEX.', Setting_1.default.value('profileDir'));
            return (0, locale_1._)('The sync target cannot be changed for the following reason: %s\n\nIf the issue cannot be resolved, you may need to clear your data first by following these instructions:\n\n%s', message, resolutionMessage);
        }
        return '';
    },
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const validateSetting = async (settingName, oldValue, newValue) => {
    if (oldValue === newValue)
        return '';
    if (!validations[settingName])
        return '';
    return await validations[settingName](oldValue, newValue);
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
exports.default = async (settingKeys, newValues) => {
    for (const key of settingKeys) {
        const oldValue = Setting_1.default.value(key);
        const newValue = newValues[key];
        const message = await validateSetting(key, oldValue, newValue);
        return message;
    }
    return '';
};
//# sourceMappingURL=settingValidations.js.map