"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const RemoteMessenger_1 = require("./RemoteMessenger");
class WorkerToWindowMessenger extends RemoteMessenger_1.default {
    constructor(channelId, localApi) {
        super(channelId, localApi);
        this.handleMessageEvent = (event) => {
            void this.onMessage(event.data);
        };
        self.addEventListener('message', this.handleMessageEvent);
        this.onReadyToReceive();
    }
    postMessage(message) {
        self.postMessage(message);
    }
    onClose() {
        self.removeEventListener('message', this.handleMessageEvent);
    }
}
exports.default = WorkerToWindowMessenger;
//# sourceMappingURL=WorkerToWindowMessenger.js.map