"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const linkReplacement_1 = require("../linkReplacement");
const utils = require("../../utils");
const urlUtils = require('../../urlUtils.js');
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function plugin(markdownIt, ruleOptions) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    markdownIt.renderer.rules.link_open = function (tokens, idx) {
        const token = tokens[idx];
        const href = utils.getAttr(token.attrs, 'href');
        const resourceHrefInfo = urlUtils.parseResourceUrl(href);
        const isResourceUrl = ruleOptions.resources && !!resourceHrefInfo;
        const title = utils.getAttr(token.attrs, 'title', isResourceUrl ? '' : href);
        const replacement = (0, linkReplacement_1.default)(href, {
            title,
            resources: ruleOptions.resources,
            ResourceModel: ruleOptions.ResourceModel,
            linkRenderingType: ruleOptions.linkRenderingType,
            plainResourceRendering: ruleOptions.plainResourceRendering,
            postMessageSyntax: ruleOptions.postMessageSyntax,
            enableLongPress: ruleOptions.enableLongPress,
            itemIdToUrl: ruleOptions.itemIdToUrl,
        });
        ruleOptions.context.currentLinks.push({
            href: href,
            resource: replacement.resource,
            resourceReady: replacement.resourceReady,
            resourceFullPath: replacement.resourceFullPath,
        });
        return replacement.html;
    };
}
exports.default = { plugin };
//# sourceMappingURL=link_open.js.map