'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClassNameForExtension = getClassNameForExtension;
exports.getIconForExtension = getIconForExtension;
exports.getExtensionForFilename = getExtensionForFilename;
exports.getClassNameForFilename = getClassNameForFilename;
exports.getIconForFilename = getIconForFilename;
exports.getClassNameForMimeType = getClassNameForMimeType;
exports.getIconForMimeType = getIconForMimeType;

var _extensions = require('./extensions');

var _extensions2 = _interopRequireDefault(_extensions);

var _mimetypes = require('./mimetypes');

var _mimetypes2 = _interopRequireDefault(_mimetypes);

var _icons = require('./icons');

var _icons2 = _interopRequireDefault(_icons);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @param {string} extension
 * @returns {string}
 */
function getClassNameForExtension(extension) {
  return _extensions2.default[extension.toLowerCase()] || _icons2.default.file;
}

/**
 * @param {string} extension
 * @returns {string}
 */
function getIconForExtension(extension) {
  return '<i class="fa ' + getClassNameForExtension(extension) + '"></i>';
}

/**
 * @param {string} extension
 * @returns {string}
 */
function getExtensionForFilename(filename) {
  return filename.slice((filename.lastIndexOf('.') - 1 >>> 0) + 2);
}

/**
 * @param {string} extension
 * @returns {string}
 */
function getClassNameForFilename(filename) {
  return getClassNameForExtension(getExtensionForFilename(filename));
}

/**
 * @param {string} extension
 * @returns {string}
 */
function getIconForFilename(filename) {
  return getIconForExtension(getExtensionForFilename(filename));
}

/**
 * @param {string} mimeType
 * @returns {string}
 */
function getClassNameForMimeType(mimeType) {
  return _mimetypes2.default[mimeType.toLowerCase()] || _icons2.default.file;
}

/**
 * @param {string} mimeType
 * @returns {string}
 */
function getIconForMimeType(mimeType) {
  return '<i class="fa ' + getClassNameForMimeType(mimeType) + '"></i>';
}

exports.default = getClassNameForExtension;