#!/usr/bin/env node
/*
	Terminal Kit

	Copyright (c) 2009 - 2021 Cédric Ronvel

	The MIT License (MIT)

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.
*/

"use strict" ;



const termkit = require( '../../lib/termkit.js' ) ;
const term = termkit.terminal ;



term.clear() ;

var document = term.createDocument() ;

var inlineInput = new termkit.InlineInput( {
	parent: document ,
	textAttr: { bgColor: 'blue' } ,
	voidAttr: { bgColor: 'blue' } ,
	placeholder: 'Your name here' ,
	x: 0 ,
	y: 10 ,
	//*
	prompt: {
		textAttr: { bgColor: 'blue' } ,
		content: '^R^+a big ^Gbig ^Ybig ^Rprompt>^:^B ' ,
		contentHasMarkup: true
	} ,
	//*/
	//firstLineRightShift: 8 ,
	//width: 36 ,
	width: 100 ,
	cancelable: true ,
	value: 'toto' ,
	history: [ 'Bob' , 'Bill' , 'Jack' , 'Some entry string' ] ,
	autoComplete: [ 'Barack Obama' , 'George W. Bush' , 'Bill Clinton' , 'George Bush' , 'Ronald W. Reagan' , 'Jimmy Carter' , 'Gerald Ford' , 'Richard Nixon' , 'Lyndon Johnson' , 'John F. Kennedy' , 'Dwight Eisenhower' , 'Harry Truman' , 'Franklin Roosevelt' ] ,
	autoCompleteMenu: true ,
	autoCompleteHint: true ,
} ) ;

inlineInput.on( 'submit' , onSubmit ) ;

function onSubmit( value ) {
	//console.error( 'Submitted: ' , value ) ;
	term.saveCursor() ;
	term.moveTo.styleReset.eraseLine( 1 , 22 , "Submitted: '%s'\n" , value ) ;
	term.restoreCursor() ;
}

inlineInput.on( 'cancel' , onCancel ) ;

function onCancel() {
	//console.error( 'Submitted: ' , value ) ;
	term.saveCursor() ;
	term.moveTo.styleReset.eraseLine( 1 , 22 , 'Canceled\n' ) ;
	term.restoreCursor() ;
}

document.focusNext() ;



term.on( 'key' , function( key ) {
	switch( key ) {
		case 'CTRL_C' :
			term.grabInput( false ) ;
			term.hideCursor( false ) ;
			term.styleReset() ;
			term.clear() ;
			process.exit() ;
			break ;
	}
} ) ;

