"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("@joplin/lib/locale");
const registry_js_1 = require("@joplin/lib/registry.js");
class BaseCommand {
    constructor() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        this.stdout_ = null;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        this.prompt_ = null;
    }
    usage() {
        throw new Error('Usage not defined');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    encryptionCheck(item) {
        if (item && item.encryption_applied)
            throw new Error((0, locale_1._)('Cannot change encrypted item'));
    }
    description() {
        throw new Error('Description not defined');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(_args) {
        throw new Error('Action not defined');
    }
    compatibleUis() {
        return ['cli', 'gui'];
    }
    supportsUi(ui) {
        return this.compatibleUis().indexOf(ui) >= 0;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    options() {
        return [];
    }
    hidden() {
        return false;
    }
    enabled() {
        return true;
    }
    cancellable() {
        return false;
    }
    async cancel() { }
    name() {
        const r = this.usage().split(' ');
        return r[0];
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    setDispatcher(fn) {
        this.dispatcher_ = fn;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    dispatch(action) {
        if (!this.dispatcher_)
            throw new Error('Dispatcher not defined');
        return this.dispatcher_(action);
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    setStdout(fn) {
        this.stdout_ = fn;
    }
    stdout(text) {
        if (this.stdout_)
            this.stdout_(text);
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    setPrompt(fn) {
        this.prompt_ = fn;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async prompt(message, options = null) {
        if (!this.prompt_)
            throw new Error('Prompt is undefined');
        return await this.prompt_(message, options);
    }
    metadata() {
        return {
            name: this.name(),
            usage: this.usage(),
            options: this.options(),
            hidden: this.hidden(),
        };
    }
    logger() {
        return registry_js_1.reg.logger();
    }
}
exports.default = BaseCommand;
//# sourceMappingURL=base-command.js.map