"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const Note_1 = require("@joplin/lib/models/Note");
class Command extends base_command_1.default {
    usage() {
        return 'cp <note> [notebook]';
    }
    description() {
        return (0, locale_1._)('Duplicates the notes matching <note> to [notebook]. If no notebook is specified the note is duplicated in the current notebook.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        let folder = null;
        if (args['notebook']) {
            folder = await (0, app_1.default)().loadItem(BaseModel_1.default.TYPE_FOLDER, args['notebook']);
        }
        else {
            folder = (0, app_1.default)().currentFolder();
        }
        if (!folder)
            throw new Error((0, locale_1._)('Cannot find "%s".', args['notebook']));
        const notes = await (0, app_1.default)().loadItems(BaseModel_1.default.TYPE_NOTE, args['note']);
        if (!notes.length)
            throw new Error((0, locale_1._)('Cannot find "%s".', args['note']));
        for (let i = 0; i < notes.length; i++) {
            const newNote = await Note_1.default.copyToFolder(notes[i].id, folder.id);
            void Note_1.default.updateGeolocation(newNote.id);
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-cp.js.map